<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AdminSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \DB::table('admin_settings')->updateOrInsert(
            ['id' => 1],
            [
                'writer_fee' => 20.00,
                'writer_deadline' => 40.00,
                'enable_coupon' => 1,
                'price_per_slide' => 4.00,
                'enable_stripe_payment' => 1,
                'questions_test_duration' => 10,
                'essay_test_duration' => 15,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        );

        // Payment Impact Settings
        \DB::table('admin_settings')->where('id', 1)->update([
            'quality_bonus' => 5.00,
            'quality_penalty' => 10.00,
            'delay_penalty_per_hour' => 0.50,
        ]);
    }
}
