<?php

namespace Database\Seeders;

use App\Models\BlogAuthor;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BlogAuthorSeeder extends Seeder
{
    public function run()
    {
        $authors = [
            [
                'name' => 'Academic Scribe Team',
                'email' => 'team@academicscribe.com',
                'bio' => 'Our team of experienced academic writers, researchers, and educators brings decades of combined expertise in helping students achieve academic success. We specialize in providing expert guidance on essay writing, research methodology, and academic communication.',
                'avatar' => null,
                'social_links' => [
                    'website' => 'https://academicscribe.com',
                    'twitter' => '@AcademicScribe',
                    'linkedin' => 'academic-scribe',
                    'facebook' => 'academicscribe',
                ],
            ],
            [
                'name' => 'Dr. Sarah Mitchell',
                'email' => 'sarah.mitchell@academicscribe.com',
                'bio' => 'Dr. Sarah Mitchell is a seasoned academic writer and educator with over 15 years of experience in higher education. She holds a PhD in English Literature and has published numerous articles on academic writing pedagogy. Sarah specializes in essay writing, research methodology, and academic communication.',
                'avatar' => null,
                'social_links' => [
                    'linkedin' => 'dr-sarah-mitchell',
                    'twitter' => '@DrSarahMitchell',
                    'orcid' => '0000-0000-0000-0000',
                ],
            ],
            [
                'name' => 'Prof. Michael Johnson',
                'email' => 'michael.johnson@academicscribe.com',
                'bio' => 'Professor Michael Johnson is a research methodology expert with a background in social sciences. He has guided hundreds of students through their dissertation and thesis writing processes. Michael specializes in quantitative research methods, data analysis, and academic research design.',
                'avatar' => null,
                'social_links' => [
                    'linkedin' => 'prof-michael-johnson',
                    'researchgate' => 'Michael_Johnson',
                    'orcid' => '0000-0000-0000-0001',
                ],
            ],
        ];

        foreach ($authors as $author) {
            BlogAuthor::create($author);
        }
    }
}
