<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CountriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $countries = [
            ['name' => 'Afghanistan', 'code' => 'AFG', 'dialing_code' => '+93'],
            ['name' => 'Albania', 'code' => 'ALB', 'dialing_code' => '+355'],
            ['name' => 'Algeria', 'code' => 'DZA', 'dialing_code' => '+213'],
            ['name' => 'Andorra', 'code' => 'AND', 'dialing_code' => '+376'],
            ['name' => 'Angola', 'code' => 'AGO', 'dialing_code' => '+244'],
            ['name' => 'Antigua and Barbuda', 'code' => 'ATG', 'dialing_code' => '+1-268'],
            ['name' => 'Argentina', 'code' => 'ARG', 'dialing_code' => '+54'],
            ['name' => 'Armenia', 'code' => 'ARM', 'dialing_code' => '+374'],
            ['name' => 'Australia', 'code' => 'AUS', 'dialing_code' => '+61'],
            ['name' => 'Austria', 'code' => 'AUT', 'dialing_code' => '+43'],
            ['name' => 'Azerbaijan', 'code' => 'AZE', 'dialing_code' => '+994'],
            ['name' => 'Bahamas', 'code' => 'BHS', 'dialing_code' => '+1-242'],
            ['name' => 'Bahrain', 'code' => 'BHR', 'dialing_code' => '+973'],
            ['name' => 'Bangladesh', 'code' => 'BGD', 'dialing_code' => '+880'],
            ['name' => 'Barbados', 'code' => 'BRB', 'dialing_code' => '+1-246'],
            ['name' => 'Belarus', 'code' => 'BLR', 'dialing_code' => '+375'],
            ['name' => 'Belgium', 'code' => 'BEL', 'dialing_code' => '+32'],
            ['name' => 'Belize', 'code' => 'BLZ', 'dialing_code' => '+501'],
            ['name' => 'Benin', 'code' => 'BEN', 'dialing_code' => '+229'],
            ['name' => 'Bhutan', 'code' => 'BTN', 'dialing_code' => '+975'],
            ['name' => 'Bolivia', 'code' => 'BOL', 'dialing_code' => '+591'],
            ['name' => 'Bosnia and Herzegovina', 'code' => 'BIH', 'dialing_code' => '+387'],
            ['name' => 'Botswana', 'code' => 'BWA', 'dialing_code' => '+267'],
            ['name' => 'Brazil', 'code' => 'BRA', 'dialing_code' => '+55'],
            ['name' => 'Brunei', 'code' => 'BRN', 'dialing_code' => '+673'],
            ['name' => 'Bulgaria', 'code' => 'BGR', 'dialing_code' => '+359'],
            ['name' => 'Burkina Faso', 'code' => 'BFA', 'dialing_code' => '+226'],
            ['name' => 'Burundi', 'code' => 'BDI', 'dialing_code' => '+257'],
            ['name' => 'Cabo Verde', 'code' => 'CPV', 'dialing_code' => '+238'],
            ['name' => 'Cambodia', 'code' => 'KHM', 'dialing_code' => '+855'],
            ['name' => 'Cameroon', 'code' => 'CMR', 'dialing_code' => '+237'],
            ['name' => 'Canada', 'code' => 'CAN', 'dialing_code' => '+1'],
            ['name' => 'Central African Republic', 'code' => 'CAF', 'dialing_code' => '+236'],
            ['name' => 'Chad', 'code' => 'TCD', 'dialing_code' => '+235'],
            ['name' => 'Chile', 'code' => 'CHL', 'dialing_code' => '+56'],
            ['name' => 'China', 'code' => 'CHN', 'dialing_code' => '+86'],
            ['name' => 'Colombia', 'code' => 'COL', 'dialing_code' => '+57'],
            ['name' => 'Comoros', 'code' => 'COM', 'dialing_code' => '+269'],
            ['name' => 'Congo', 'code' => 'COG', 'dialing_code' => '+242'],
            ['name' => 'Costa Rica', 'code' => 'CRI', 'dialing_code' => '+506'],
            ['name' => 'Croatia', 'code' => 'HRV', 'dialing_code' => '+385'],
            ['name' => 'Cuba', 'code' => 'CUB', 'dialing_code' => '+53'],
            ['name' => 'Cyprus', 'code' => 'CYP', 'dialing_code' => '+357'],
            ['name' => 'Czech Republic', 'code' => 'CZE', 'dialing_code' => '+420'],
            ['name' => 'Denmark', 'code' => 'DNK', 'dialing_code' => '+45'],
            ['name' => 'Djibouti', 'code' => 'DJI', 'dialing_code' => '+253'],
            ['name' => 'Dominica', 'code' => 'DMA', 'dialing_code' => '+1-767'],
            ['name' => 'Dominican Republic', 'code' => 'DOM', 'dialing_code' => '+1-809'],
            ['name' => 'Ecuador', 'code' => 'ECU', 'dialing_code' => '+593'],
            ['name' => 'Egypt', 'code' => 'EGY', 'dialing_code' => '+20'],
            ['name' => 'El Salvador', 'code' => 'SLV', 'dialing_code' => '+503'],
            ['name' => 'Equatorial Guinea', 'code' => 'GNQ', 'dialing_code' => '+240'],
            ['name' => 'Eritrea', 'code' => 'ERI', 'dialing_code' => '+291'],
            ['name' => 'Estonia', 'code' => 'EST', 'dialing_code' => '+372'],
            ['name' => 'Eswatini', 'code' => 'SWZ', 'dialing_code' => '+268'],
            ['name' => 'Ethiopia', 'code' => 'ETH', 'dialing_code' => '+251'],
            ['name' => 'Fiji', 'code' => 'FJI', 'dialing_code' => '+679'],
            ['name' => 'Finland', 'code' => 'FIN', 'dialing_code' => '+358'],
            ['name' => 'France', 'code' => 'FRA', 'dialing_code' => '+33'],
            ['name' => 'Gabon', 'code' => 'GAB', 'dialing_code' => '+241'],
            ['name' => 'Gambia', 'code' => 'GMB', 'dialing_code' => '+220'],
            ['name' => 'Georgia', 'code' => 'GEO', 'dialing_code' => '+995'],
            ['name' => 'Germany', 'code' => 'DEU', 'dialing_code' => '+49'],
            ['name' => 'Ghana', 'code' => 'GHA', 'dialing_code' => '+233'],
            ['name' => 'Greece', 'code' => 'GRC', 'dialing_code' => '+30'],
            ['name' => 'Grenada', 'code' => 'GRD', 'dialing_code' => '+1-473'],
            ['name' => 'Guatemala', 'code' => 'GTM', 'dialing_code' => '+502'],
            ['name' => 'Guinea', 'code' => 'GIN', 'dialing_code' => '+224'],
            ['name' => 'Guinea-Bissau', 'code' => 'GNB', 'dialing_code' => '+245'],
            ['name' => 'Guyana', 'code' => 'GUY', 'dialing_code' => '+592'],
            ['name' => 'Haiti', 'code' => 'HTI', 'dialing_code' => '+509'],
            ['name' => 'Honduras', 'code' => 'HND', 'dialing_code' => '+504'],
            ['name' => 'Hungary', 'code' => 'HUN', 'dialing_code' => '+36'],
            ['name' => 'Iceland', 'code' => 'ISL', 'dialing_code' => '+354'],
            ['name' => 'India', 'code' => 'IND', 'dialing_code' => '+91'],
            ['name' => 'Indonesia', 'code' => 'IDN', 'dialing_code' => '+62'],
            ['name' => 'Iran', 'code' => 'IRN', 'dialing_code' => '+98'],
            ['name' => 'Iraq', 'code' => 'IRQ', 'dialing_code' => '+964'],
            ['name' => 'Ireland', 'code' => 'IRL', 'dialing_code' => '+353'],
            ['name' => 'Israel', 'code' => 'ISR', 'dialing_code' => '+972'],
            ['name' => 'Italy', 'code' => 'ITA', 'dialing_code' => '+39'],
            ['name' => 'Jamaica', 'code' => 'JAM', 'dialing_code' => '+1-876'],
            ['name' => 'Japan', 'code' => 'JPN', 'dialing_code' => '+81'],
            ['name' => 'Jordan', 'code' => 'JOR', 'dialing_code' => '+962'],
            ['name' => 'Kazakhstan', 'code' => 'KAZ', 'dialing_code' => '+7'],
            ['name' => 'Kenya', 'code' => 'KEN', 'dialing_code' => '+254'],
            ['name' => 'Kiribati', 'code' => 'KIR', 'dialing_code' => '+686'],
            ['name' => 'Korea, North', 'code' => 'PRK', 'dialing_code' => '+850'],
            ['name' => 'Korea, South', 'code' => 'KOR', 'dialing_code' => '+82'],
            ['name' => 'Kosovo', 'code' => 'XKX', 'dialing_code' => '+383'],
            ['name' => 'Kuwait', 'code' => 'KWT', 'dialing_code' => '+965'],
            ['name' => 'Kyrgyzstan', 'code' => 'KGZ', 'dialing_code' => '+996'],
            ['name' => 'Laos', 'code' => 'LAO', 'dialing_code' => '+856'],
            ['name' => 'Latvia', 'code' => 'LVA', 'dialing_code' => '+371'],
            ['name' => 'Lebanon', 'code' => 'LBN', 'dialing_code' => '+961'],
            ['name' => 'Lesotho', 'code' => 'LSO', 'dialing_code' => '+266'],
            ['name' => 'Liberia', 'code' => 'LBR', 'dialing_code' => '+231'],
            ['name' => 'Libya', 'code' => 'LBY', 'dialing_code' => '+218'],
            ['name' => 'Liechtenstein', 'code' => 'LIE', 'dialing_code' => '+423'],
            ['name' => 'Lithuania', 'code' => 'LTU', 'dialing_code' => '+370'],
            ['name' => 'Luxembourg', 'code' => 'LUX', 'dialing_code' => '+352'],
            ['name' => 'Madagascar', 'code' => 'MDG', 'dialing_code' => '+261'],
            ['name' => 'Malawi', 'code' => 'MWI', 'dialing_code' => '+265'],
            ['name' => 'Malaysia', 'code' => 'MYS', 'dialing_code' => '+60'],
            ['name' => 'Maldives', 'code' => 'MDV', 'dialing_code' => '+960'],
            ['name' => 'Mali', 'code' => 'MLI', 'dialing_code' => '+223'],
            ['name' => 'Malta', 'code' => 'MLT', 'dialing_code' => '+356'],
            ['name' => 'Marshall Islands', 'code' => 'MHL', 'dialing_code' => '+692'],
            ['name' => 'Mauritania', 'code' => 'MRT', 'dialing_code' => '+222'],
            ['name' => 'Mauritius', 'code' => 'MUS', 'dialing_code' => '+230'],
            ['name' => 'Mexico', 'code' => 'MEX', 'dialing_code' => '+52'],
            ['name' => 'Micronesia', 'code' => 'FSM', 'dialing_code' => '+691'],
            ['name' => 'Moldova', 'code' => 'MDA', 'dialing_code' => '+373'],
            ['name' => 'Monaco', 'code' => 'MCO', 'dialing_code' => '+377'],
            ['name' => 'Mongolia', 'code' => 'MNG', 'dialing_code' => '+976'],
            ['name' => 'Montenegro', 'code' => 'MNE', 'dialing_code' => '+382'],
            ['name' => 'Morocco', 'code' => 'MAR', 'dialing_code' => '+212'],
            ['name' => 'Mozambique', 'code' => 'MOZ', 'dialing_code' => '+258'],
            ['name' => 'Myanmar', 'code' => 'MMR', 'dialing_code' => '+95'],
            ['name' => 'Namibia', 'code' => 'NAM', 'dialing_code' => '+264'],
            ['name' => 'Nauru', 'code' => 'NRU', 'dialing_code' => '+674'],
            ['name' => 'Nepal', 'code' => 'NPL', 'dialing_code' => '+977'],
            ['name' => 'Netherlands', 'code' => 'NLD', 'dialing_code' => '+31'],
            ['name' => 'New Zealand', 'code' => 'NZL', 'dialing_code' => '+64'],
            ['name' => 'Nicaragua', 'code' => 'NIC', 'dialing_code' => '+505'],
            ['name' => 'Niger', 'code' => 'NER', 'dialing_code' => '+227'],
            ['name' => 'Nigeria', 'code' => 'NGA', 'dialing_code' => '+234'],
            ['name' => 'North Macedonia', 'code' => 'MKD', 'dialing_code' => '+389'],
            ['name' => 'Norway', 'code' => 'NOR', 'dialing_code' => '+47'],
            ['name' => 'Oman', 'code' => 'OMN', 'dialing_code' => '+968'],
            ['name' => 'Pakistan', 'code' => 'PAK', 'dialing_code' => '+92'],
            ['name' => 'Palau', 'code' => 'PLW', 'dialing_code' => '+680'],
            ['name' => 'Palestine', 'code' => 'PSE', 'dialing_code' => '+970'],
            ['name' => 'Panama', 'code' => 'PAN', 'dialing_code' => '+507'],
            ['name' => 'Papua New Guinea', 'code' => 'PNG', 'dialing_code' => '+675'],
            ['name' => 'Paraguay', 'code' => 'PRY', 'dialing_code' => '+595'],
            ['name' => 'Peru', 'code' => 'PER', 'dialing_code' => '+51'],
            ['name' => 'Philippines', 'code' => 'PHL', 'dialing_code' => '+63'],
            ['name' => 'Poland', 'code' => 'POL', 'dialing_code' => '+48'],
            ['name' => 'Portugal', 'code' => 'PRT', 'dialing_code' => '+351'],
            ['name' => 'Qatar', 'code' => 'QAT', 'dialing_code' => '+974'],
            ['name' => 'Romania', 'code' => 'ROU', 'dialing_code' => '+40'],
            ['name' => 'Russia', 'code' => 'RUS', 'dialing_code' => '+7'],
            ['name' => 'Rwanda', 'code' => 'RWA', 'dialing_code' => '+250'],
            ['name' => 'Saint Kitts and Nevis', 'code' => 'KNA', 'dialing_code' => '+1-869'],
            ['name' => 'Saint Lucia', 'code' => 'LCA', 'dialing_code' => '+1-758'],
            ['name' => 'Saint Vincent and the Grenadines', 'code' => 'VCT', 'dialing_code' => '+1-784'],
            ['name' => 'Samoa', 'code' => 'WSM', 'dialing_code' => '+685'],
            ['name' => 'San Marino', 'code' => 'SMR', 'dialing_code' => '+378'],
            ['name' => 'Sao Tome and Principe', 'code' => 'STP', 'dialing_code' => '+239'],
            ['name' => 'Saudi Arabia', 'code' => 'SAU', 'dialing_code' => '+966'],
            ['name' => 'Senegal', 'code' => 'SEN', 'dialing_code' => '+221'],
            ['name' => 'Serbia', 'code' => 'SRB', 'dialing_code' => '+381'],
            ['name' => 'Seychelles', 'code' => 'SYC', 'dialing_code' => '+248'],
            ['name' => 'Sierra Leone', 'code' => 'SLE', 'dialing_code' => '+232'],
            ['name' => 'Singapore', 'code' => 'SGP', 'dialing_code' => '+65'],
            ['name' => 'Slovakia', 'code' => 'SVK', 'dialing_code' => '+421'],
            ['name' => 'Slovenia', 'code' => 'SVN', 'dialing_code' => '+386'],
            ['name' => 'Solomon Islands', 'code' => 'SLB', 'dialing_code' => '+677'],
            ['name' => 'Somalia', 'code' => 'SOM', 'dialing_code' => '+252'],
            ['name' => 'South Africa', 'code' => 'ZAF', 'dialing_code' => '+27'],
            ['name' => 'South Sudan', 'code' => 'SSD', 'dialing_code' => '+211'],
            ['name' => 'Spain', 'code' => 'ESP', 'dialing_code' => '+34'],
            ['name' => 'Sri Lanka', 'code' => 'LKA', 'dialing_code' => '+94'],
            ['name' => 'Sudan', 'code' => 'SDN', 'dialing_code' => '+249'],
            ['name' => 'Suriname', 'code' => 'SUR', 'dialing_code' => '+597'],
            ['name' => 'Sweden', 'code' => 'SWE', 'dialing_code' => '+46'],
            ['name' => 'Switzerland', 'code' => 'CHE', 'dialing_code' => '+41'],
            ['name' => 'Syria', 'code' => 'SYR', 'dialing_code' => '+963'],
            ['name' => 'Taiwan', 'code' => 'TWN', 'dialing_code' => '+886'],
            ['name' => 'Tajikistan', 'code' => 'TJK', 'dialing_code' => '+992'],
            ['name' => 'Tanzania', 'code' => 'TZA', 'dialing_code' => '+255'],
            ['name' => 'Thailand', 'code' => 'THA', 'dialing_code' => '+66'],
            ['name' => 'Timor-Leste', 'code' => 'TLS', 'dialing_code' => '+670'],
            ['name' => 'Togo', 'code' => 'TGO', 'dialing_code' => '+228'],
            ['name' => 'Tonga', 'code' => 'TON', 'dialing_code' => '+676'],
            ['name' => 'Trinidad and Tobago', 'code' => 'TTO', 'dialing_code' => '+1-868'],
            ['name' => 'Tunisia', 'code' => 'TUN', 'dialing_code' => '+216'],
            ['name' => 'Turkey', 'code' => 'TUR', 'dialing_code' => '+90'],
            ['name' => 'Turkmenistan', 'code' => 'TKM', 'dialing_code' => '+993'],
            ['name' => 'Tuvalu', 'code' => 'TUV', 'dialing_code' => '+688'],
            ['name' => 'Uganda', 'code' => 'UGA', 'dialing_code' => '+256'],
            ['name' => 'Ukraine', 'code' => 'UKR', 'dialing_code' => '+380'],
            ['name' => 'United Arab Emirates', 'code' => 'ARE', 'dialing_code' => '+971'],
            ['name' => 'United Kingdom', 'code' => 'GBR', 'dialing_code' => '+44'],
            ['name' => 'United States', 'code' => 'USA', 'dialing_code' => '+1'],
            ['name' => 'Uruguay', 'code' => 'URY', 'dialing_code' => '+598'],
            ['name' => 'Uzbekistan', 'code' => 'UZB', 'dialing_code' => '+998'],
            ['name' => 'Vanuatu', 'code' => 'VUT', 'dialing_code' => '+678'],
            ['name' => 'Vatican City', 'code' => 'VAT', 'dialing_code' => '+39-06'],
            ['name' => 'Venezuela', 'code' => 'VEN', 'dialing_code' => '+58'],
            ['name' => 'Vietnam', 'code' => 'VNM', 'dialing_code' => '+84'],
            ['name' => 'Yemen', 'code' => 'YEM', 'dialing_code' => '+967'],
            ['name' => 'Zambia', 'code' => 'ZMB', 'dialing_code' => '+260'],
            ['name' => 'Zimbabwe', 'code' => 'ZWE', 'dialing_code' => '+263'],
        ];

        // Add timestamps to each country
        $now = Carbon::now();
        foreach ($countries as &$country) {
            $country['created_at'] = $now;
            $country['updated_at'] = $now;
        }

        // Insert all countries into the database
        DB::table('countries')->insert($countries);
    }
}
