<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\Order;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(20)->create();
        // Order::factory()->count(50)->create();
        // User::factory()->create([
        //     'name' => 'Test User',
        //     'email' => 'test@example.com',
        // ]);

        $this->call([
            // Core system settings
            AdminSettingsSeeder::class,
            
            // Academic data
            AcademicLevelsSeeder::class,
            AcademicSubjectsSeeder::class,
            SubjectsSeeder::class,
            PaperTypesSeeder::class,
            PricingSeeder::class,
            
            // Countries and languages
            CountriesTableSeeder::class,
            LanguagesSeeder::class,
            
            // Currency and payment methods
            CurrenciesSeeder::class,
            PaymentMethodsSeeder::class,
            
            // User management
            UsersSeeder::class,
            
            // Coupons and loyalty
            LoyaltyTiersSeeder::class,
            UserCouponsSeeder::class,
            
            // Essay topics
            EssayTopicsSeeder::class,
            
            // Blog system
            BlogCategoriesSeeder::class,
            BlogAuthorSeeder::class,
            
            // Writer system
            WriterCitationStylesSeeder::class,
            WriterEducationLevelsSeeder::class,
            WriterLevelsSeeder::class,
            WriterPaymentMethodsSeeder::class,
            WriterSpecializationsSeeder::class,
            WriterCitationStyleSeeder::class,
            
            // Notification preferences
            NotificationPreferencesSeeder::class,
        ]);
    }
}
