<?php

namespace Database\Seeders;

use App\Models\FooterSetting;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class FooterSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing footer settings
        FooterSetting::truncate();

        // Company Information
        FooterSetting::create([
            'key' => 'company_info',
            'section_type' => 'company_info',
            'data' => [
                'title' => 'Academic Scribe',
                'description' => 'Professional <strong>academic writing services</strong> with expert <strong>dissertation writing help</strong> and <strong>research paper writing service</strong> from qualified <strong>professional essay writers</strong>.',
            ],
            'order' => 1,
            'is_active' => true,
        ]);

        // Service Links
        $serviceLinks = [
            ['name' => 'Dissertation Writing Help', 'url' => '/services/dissertation-writing', 'order' => 1],
            ['name' => 'Research Paper Writing Service', 'url' => '/services/research-papers', 'order' => 2],
            ['name' => 'Case Studies Writing', 'url' => '/services/case-studies', 'order' => 3],
            ['name' => 'Literature Reviews', 'url' => '/services/literature-reviews', 'order' => 4],
            ['name' => 'Thesis Proposals', 'url' => '/services/thesis-proposals', 'order' => 5],
        ];

        foreach ($serviceLinks as $link) {
            FooterSetting::create([
                'key' => 'service_link_' . str_replace('-', '_', basename($link['url'])),
                'section_type' => 'service_link',
                'data' => [
                    'name' => $link['name'],
                    'url' => $link['url'],
                ],
                'order' => $link['order'],
                'is_active' => true,
            ]);
        }

        // Quick Links
        $quickLinks = [
            ['name' => 'Home', 'url' => '/', 'order' => 1],
            ['name' => 'Services', 'url' => '/services', 'order' => 2],
            ['name' => 'About Us', 'url' => '/about', 'order' => 3],
            ['name' => 'Guarantees', 'url' => '/guarantees', 'order' => 4],
            ['name' => 'Contact', 'url' => '/contact', 'order' => 5],
        ];

        foreach ($quickLinks as $link) {
            FooterSetting::create([
                'key' => 'quick_link_' . str_replace('-', '_', trim($link['url'], '/')),
                'section_type' => 'quick_link',
                'data' => [
                    'name' => $link['name'],
                    'url' => $link['url'],
                ],
                'order' => $link['order'],
                'is_active' => true,
            ]);
        }

        // Contact Information
        FooterSetting::create([
            'key' => 'contact_info',
            'section_type' => 'contact_info',
            'data' => [
                'email' => 'support@academicscribe.com',
                'phone' => '+1 (555) 123-4567',
                'phone_description' => '24/7 Academic Writing Support',
                'address' => [
                    'line1' => 'Academic Writing Center',
                    'line2' => '123 Scholar Street',
                    'line3' => 'Boston, MA 02108',
                ],
            ],
            'order' => 1,
            'is_active' => true,
        ]);

        // Legal Links
        $legalLinks = [
            ['name' => 'DMCA', 'url' => 'https://www.dmca.com/r/28x3kdd', 'external' => true, 'order' => 1],
            ['name' => 'Privacy Policy', 'url' => '/privacy-policy', 'external' => false, 'order' => 2],
            ['name' => 'Terms of Service', 'url' => '/terms-of-service', 'external' => false, 'order' => 3],
            ['name' => 'Cookie Policy', 'url' => '/cookie-policy', 'external' => false, 'order' => 4],
        ];

        foreach ($legalLinks as $link) {
            FooterSetting::create([
                'key' => 'legal_link_' . strtolower(str_replace(' ', '_', $link['name'])),
                'section_type' => 'legal_link',
                'data' => [
                    'name' => $link['name'],
                    'url' => $link['url'],
                    'external' => $link['external'],
                ],
                'order' => $link['order'],
                'is_active' => true,
            ]);
        }

        // Copyright text
        FooterSetting::create([
            'key' => 'copyright_text',
            'section_type' => 'company_info',
            'data' => [
                'text' => 'Academic Scribe - Professional Academic Writing Services. All rights reserved.',
            ],
            'order' => 2,
            'is_active' => true,
        ]);
    }
}
