<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Services\PageService;
use Carbon\Carbon;

class HomepageSeeder extends Seeder
{
    protected PageService $pageService;

    public function __construct(PageService $pageService)
    {
        $this->pageService = $pageService;
    }

    public function run(): void
    {
        $this->command->info('Creating homepage content...');

        // Define the complete homepage data
        $homepageData = [
            'slug' => 'homepage',
            'title' => 'Academic Writing Services | Professional Essay Writers | AcademicScribe',
            'page_type' => 'homepage',
            'status' => 'published',
            'parent_id' => null,
            'template' => 'homepage',
            'seo_priority' => 1,
            'published_at' => Carbon::now(),
        ];

        // Content blocks for the homepage
        $contentBlocks = [
            // Hero Section
            [
                'block_type' => 'hero',
                'block_key' => 'main_hero',
                'content' => [
                    // Headline components (3 parts)
                    'headlinePrimary' => 'Professional Academic Writing',
                    'headlineHighlight' => 'Services',
                    'headlineSuffix' => 'for Students Worldwide',
                    
                    // Trust badge text
                    'trustText' => 'Trusted by 10,000+ students worldwide',
                    
                    // Main description (rich text)
                    'paragraph' => '<p>Leading academic writing company providing expert essay writers and dissertation writing help. Our professional academic writing service delivers custom assignments, research papers, and essays for students worldwide with guaranteed quality and originality.</p>',
                    
                    // Key benefit bullets (4 points)
                    'bullet1' => 'Expert PhD and Master\'s Writers',
                    'bullet2' => '100% Original & Plagiarism-Free',
                    'bullet3' => '24/7 Customer Support',
                    'bullet4' => 'Money-Back Guarantee',
                    
                    // CTA buttons
                    'ctaPrimaryText' => 'Get Started Now',
                    'ctaPrimaryHref' => '/place-order',
                    'ctaSecondaryText' => 'View Our Services',
                    'ctaSecondaryHref' => '/services',
                    
                    // Quick stats (3 stats)
                    'stat1Value' => '10,000+',
                    'stat1Label' => 'Happy Students',
                    'stat2Value' => '98%',
                    'stat2Label' => 'Satisfaction Rate',
                    'stat3Value' => '24/7',
                    'stat3Label' => 'Support Available',
                    
                    // Hero image
                    'heroImage' => '/images/hero-academic-writers.jpg',
                    'heroAlt' => 'Professional essay writers providing dissertation writing help and research paper writing service for custom academic papers'
                ],
                'order' => 1,
                'is_active' => true,
            ],

            // About Section
            [
                'block_type' => 'about',
                'block_key' => 'about_section',
                'content' => [
                    'title' => 'About Academic Scribe',
                    'description' => 'We are a leading academic writing company providing professional academic writing services to students worldwide. Our expert essay writers and academic writing team deliver custom assignments, dissertations, research papers, and essays with guaranteed quality and originality.',
                    'mission_title' => 'Our Mission',
                    'mission_description' => 'To provide exceptional academic writing services that empower students worldwide. As one of the leading websites that write assignments and essays for students online, we maintain the highest standards of quality, originality, and academic integrity in every project.',
                    'features' => [
                        [
                            'title' => 'Expert Writers',
                            'description' => 'PhD-qualified professionals with extensive academic experience',
                            'icon' => 'users'
                        ],
                        [
                            'title' => 'Quality Assurance',
                            'description' => 'Rigorous quality control and plagiarism checking processes',
                            'icon' => 'shield-check'
                        ],
                        [
                            'title' => '24/7 Support',
                            'description' => 'Round-the-clock customer support and assistance',
                            'icon' => 'clock'
                        ],
                        [
                            'title' => 'Original Content',
                            'description' => '100% plagiarism-free guarantee on all academic papers',
                            'icon' => 'check-circle'
                        ]
                    ],
                    'about_image' => '/images/about-academic-scribe.jpg',
                    'about_image_alt' => 'Academic Scribe professional writing team'
                ],
                'order' => 2,
                'is_active' => true,
            ],

            // Services Section
            [
                'block_type' => 'services',
                'block_key' => 'services_section',
                'content' => [
                    'title' => 'Our Academic Writing Services',
                    'subtitle' => 'Comprehensive academic writing solutions tailored to your specific needs and requirements.',
                    'services' => [
                        [
                            'title' => 'Essay Writing',
                            'description' => '<p>Professional essay writing service with expert writers specializing in all academic levels and subjects.</p>',
                            'icon' => 'file-text',
                            'link' => '/services/essay-writing',
                            'color' => 'blue',
                            'features' => [
                                'All Academic Levels',
                                '24/7 Support',
                                'Plagiarism-Free'
                            ]
                        ],
                        [
                            'title' => 'Research Papers',
                            'description' => '<p>Comprehensive research paper writing service with thorough analysis and proper citations.</p>',
                            'icon' => 'search',
                            'link' => '/services/research-papers',
                            'color' => 'green',
                            'features' => [
                                'In-depth Research',
                                'Proper Citations',
                                'Quality Assurance'
                            ]
                        ],
                        [
                            'title' => 'Dissertation Writing',
                            'description' => '<p>Expert dissertation writing help from PhD-qualified writers with extensive research experience.</p>',
                            'icon' => 'graduation-cap',
                            'link' => '/services/dissertation-writing',
                            'color' => 'purple',
                            'features' => [
                                'PhD Writers',
                                'Original Research',
                                'Timely Delivery'
                            ]
                        ],
                        [
                            'title' => 'Assignments',
                            'description' => '<p>Custom assignment writing service covering all subjects and academic requirements.</p>',
                            'icon' => 'clipboard-list',
                            'link' => '/services/assignments',
                            'color' => 'orange',
                            'features' => [
                                'All Subjects',
                                'Custom Solutions',
                                'Fast Turnaround'
                            ]
                        ],
                        [
                            'title' => 'Case Studies',
                            'description' => '<p>Professional case study analysis and writing service with detailed insights and solutions.</p>',
                            'icon' => 'bar-chart-3',
                            'link' => '/services/case-studies',
                            'color' => 'indigo',
                            'features' => [
                                'Detailed Analysis',
                                'Real Examples',
                                'Expert Insights'
                            ]
                        ],
                        [
                            'title' => 'Literature Reviews',
                            'description' => '<p>Comprehensive literature review writing service with systematic analysis and synthesis.</p>',
                            'icon' => 'book-open',
                            'link' => '/services/literature-reviews',
                            'color' => 'teal',
                            'features' => [
                                'Systematic Review',
                                'Critical Analysis',
                                'Academic Standards'
                            ]
                        ],
                        [
                            'title' => 'Thesis Proposals',
                            'description' => '<p>Professional thesis and research proposals with clear methodology and compelling research questions.</p>',
                            'icon' => 'target',
                            'link' => '/services/thesis-proposals',
                            'color' => 'pink',
                            'features' => [
                                'Research Proposals',
                                'Methodology Design',
                                'Literature Gap Analysis'
                            ]
                        ],
                        [
                            'title' => 'Programming Assignments',
                            'description' => '<p>Expert programming assistance with Python, Java, C++, and all programming languages. Professional coders with computer science degrees.</p>',
                            'icon' => 'code',
                            'link' => '/services/programming-assignments',
                            'color' => 'red',
                            'features' => [
                                'Python, Java, C++',
                                'Algorithm Design',
                                'Code Documentation'
                            ]
                        ]
                    ]
                ],
                'order' => 3,
                'is_active' => true,
            ],

            // Stats Section
            [
                'block_type' => 'stats',
                'block_key' => 'stats_section',
                'content' => [
                    'title' => 'Our Professional Essay Writers by the Numbers',
                    'subtitle' => 'The qualified professionals behind our exceptional custom academic papers',
                    'main_stats' => [
                        [
                            'number' => '98%',
                            'label' => 'Client Satisfaction Rate',
                            'description' => 'Students recommend our academic writing services',
                            'icon' => 'heart',
                            'color' => 'red',
                            'detail' => 'Based on 1,200+ verified reviews'
                        ],
                        [
                            'number' => '1,250+',
                            'label' => 'Completed Academic Projects',
                            'description' => 'Successfully delivered custom academic papers',
                            'icon' => 'book-open',
                            'color' => 'blue',
                            'detail' => 'Across all academic levels'
                        ],
                        [
                            'number' => '180+',
                            'label' => 'Professional Essay Writers',
                            'description' => 'PhD and Master\'s level academic experts',
                            'icon' => 'users',
                            'color' => 'green',
                            'detail' => 'Rigorously vetted and qualified'
                        ],
                        [
                            'number' => '35+',
                            'label' => 'Academic Disciplines Covered',
                            'description' => 'Comprehensive subject matter expertise',
                            'icon' => 'target',
                            'color' => 'purple',
                            'detail' => 'From humanities to STEM fields'
                        ]
                    ],
                    'additional_stats' => [
                        [
                            'number' => '99.8%',
                            'label' => 'On-Time Delivery',
                            'description' => 'Reliable dissertation writing help',
                            'icon' => 'clock'
                        ],
                        [
                            'number' => '24/7',
                            'label' => 'Customer Support',
                            'description' => 'Round-the-clock assistance',
                            'icon' => 'globe'
                        ],
                        [
                            'number' => '100%',
                            'label' => 'Original Content',
                            'description' => 'Plagiarism-free guarantee',
                            'icon' => 'shield'
                        ],
                        [
                            'number' => '5+ Years',
                            'label' => 'Industry Experience',
                            'description' => 'Trusted research paper writing service',
                            'icon' => 'award'
                        ],
                        [
                            'number' => '4.9/5',
                            'label' => 'Average Rating',
                            'description' => 'Exceptional service quality',
                            'icon' => 'star'
                        ],
                        [
                            'number' => '72 Hours',
                            'label' => 'Fastest Turnaround',
                            'description' => 'Urgent academic writing available',
                            'icon' => 'zap'
                        ]
                    ],
                    'writer_stats' => [
                        [
                            'label' => 'PhD Holders',
                            'count' => '120+',
                            'description' => 'Doctoral-level expertise for dissertation writing help',
                            'percentage' => 67
                        ],
                        [
                            'label' => 'Master\'s Degree Writers',
                            'count' => '60+',
                            'description' => 'Advanced degree professionals for research papers',
                            'percentage' => 33
                        ],
                        [
                            'label' => 'Years of Experience',
                            'count' => '8+ Avg',
                            'description' => 'Extensive background in academic writing services',
                            'percentage' => 85
                        ],
                        [
                            'label' => 'Published Authors',
                            'count' => '45+',
                            'description' => 'Writers with published academic research',
                            'percentage' => 25
                        ]
                    ],
                    'expertise_distribution' => [
                        [
                            'field' => 'STEM Fields',
                            'count' => '45',
                            'color' => 'blue'
                        ],
                        [
                            'field' => 'Humanities',
                            'count' => '38',
                            'color' => 'green'
                        ],
                        [
                            'field' => 'Business',
                            'count' => '32',
                            'color' => 'purple'
                        ],
                        [
                            'field' => 'Social Sciences',
                            'count' => '28',
                            'color' => 'orange'
                        ],
                        [
                            'field' => 'Health Sciences',
                            'count' => '25',
                            'color' => 'red'
                        ],
                        [
                            'field' => 'Education',
                            'count' => '22',
                            'color' => 'indigo'
                        ]
                    ]
                ],
                'order' => 4,
                'is_active' => true,
            ],

            // Testimonials Section
            [
                'block_type' => 'testimonials',
                'block_key' => 'testimonials_section',
                'content' => [
                    'title' => 'What Our Students Say',
                    'subtitle' => 'Real feedback from students who have used our academic writing services',
                    'categories' => [
                        [
                            'name' => 'Students',
                            'description' => 'Undergraduate and graduate students',
                            'icon' => 'graduation-cap',
                            'testimonials' => [
                                [
                                    'text' => 'The dissertation writing help I received was exceptional. My committee was impressed with the quality of research and writing. The professional essay writers understood exactly what was needed for my PhD program.',
                                    'author' => 'Dr. Sarah Johnson',
                                    'role' => 'PhD Graduate - Psychology',
                                    'university' => 'Stanford University',
                                    'grade' => 'A+',
                                    'service' => 'Dissertation Writing Help',
                                    'rating' => 5,
                                    'date' => 'March 2024',
                                    'verified' => true,
                                    'image' => '/images/testimonials/sarah-j.jpg'
                                ],
                                [
                                    'text' => 'I was struggling with my research paper writing and found their academic writing services through a friend\'s recommendation. The custom academic paper I received helped me understand proper research methodology and improved my overall academic performance.',
                                    'author' => 'Michael Chen',
                                    'role' => 'Master\'s Student - Business Administration',
                                    'university' => 'Harvard Business School',
                                    'grade' => 'A',
                                    'service' => 'Research Paper Writing Service',
                                    'rating' => 5,
                                    'date' => 'February 2024',
                                    'verified' => true,
                                    'image' => '/images/testimonials/michael-c.jpg'
                                ],
                                [
                                    'text' => 'As an international student, I needed help with academic writing standards. Their professional essay writers not only delivered excellent work but also taught me valuable writing techniques that I use in all my assignments now.',
                                    'author' => 'Priya Patel',
                                    'role' => 'Undergraduate - Computer Science',
                                    'university' => 'MIT',
                                    'grade' => 'A-',
                                    'service' => 'Custom Academic Papers',
                                    'rating' => 5,
                                    'date' => 'January 2024',
                                    'verified' => true,
                                    'image' => '/images/testimonials/priya-p.jpg'
                                ]
                            ]
                        ],
                        [
                            'name' => 'Researchers',
                            'description' => 'Academic researchers and faculty',
                            'icon' => 'book-open',
                            'testimonials' => [
                                [
                                    'text' => 'Their research paper writing service helped me publish in a top-tier journal. The writers have deep understanding of academic standards and research methodology. I\'ve recommended their academic writing services to several colleagues.',
                                    'author' => 'Prof. David Martinez',
                                    'role' => 'Associate Professor - Environmental Science',
                                    'university' => 'UC Berkeley',
                                    'grade' => 'A+',
                                    'service' => 'Research Paper Writing Service',
                                    'rating' => 5,
                                    'date' => 'February 2024',
                                    'verified' => true,
                                    'image' => '/images/testimonials/david-m.jpg'
                                ]
                            ]
                        ]
                    ]
                ],
                'order' => 5,
                'is_active' => true,
            ],

            // FAQs Section
            [
                'block_type' => 'faqs',
                'block_key' => 'faqs_section',
                'content' => [
                    'title' => 'Frequently Asked Questions',
                    'subtitle' => 'Everything you need to know about our academic writing services',
                    'categories' => [
                        [
                            'name' => 'General Services',
                            'icon' => 'help-circle',
                            'description' => 'Common questions about our academic writing services',
                            'faqs' => [
                                [
                                    'question' => 'What types of academic writing services do you offer?',
                                    'answer' => 'We provide comprehensive academic writing services including dissertation writing help, research paper writing service, custom academic papers, essays, case studies, literature reviews, and thesis writing. As a trusted academic writing company, our professional essay writers specialize in all academic levels from undergraduate to PhD, covering over 35 academic disciplines including STEM, humanities, business, social sciences, and health sciences. We are one of the leading websites that write assignments and essays for students online.',
                                    'keywords' => ['academic writing services', 'dissertation writing help', 'research paper writing service', 'custom academic papers', 'professional essay writers']
                                ],
                                [
                                    'question' => 'How do you ensure the quality of your academic writing services?',
                                    'answer' => 'Our quality assurance process involves multiple stages: First, we match your project with professional essay writers who have relevant expertise in your field. Then, every custom academic paper goes through rigorous editing, proofreading, and plagiarism checking. Our dissertation writing help includes methodology review, and our research paper writing service ensures proper citation and formatting. Finally, all work is reviewed by our quality control team before delivery.',
                                    'keywords' => ['academic writing services', 'professional essay writers', 'custom academic papers', 'dissertation writing help', 'research paper writing service']
                                ],
                                [
                                    'question' => 'What qualifications do your professional essay writers have?',
                                    'answer' => 'Our team consists of 180+ professional essay writers with advanced degrees. 67% hold PhD degrees from accredited universities, while 33% have Master\'s degrees in their respective fields. All writers providing dissertation writing help have doctoral-level experience, and those handling research paper writing service have published academic work. Our custom academic papers are written by experts with an average of 8+ years in academic writing services.',
                                    'keywords' => ['professional essay writers', 'dissertation writing help', 'research paper writing service', 'PhD writers', 'custom academic papers']
                                ]
                            ]
                        ],
                        [
                            'name' => 'Pricing & Payment',
                            'icon' => 'dollar-sign',
                            'description' => 'Questions about our pricing and payment options',
                            'faqs' => [
                                [
                                    'question' => 'How much do your academic writing services cost?',
                                    'answer' => 'Our pricing for academic writing services is competitive and varies based on the type of service, academic level, deadline, and complexity. Dissertation writing help typically ranges from $15-25 per page, research paper writing service from $12-20 per page, and custom academic papers from $10-18 per page. We offer discounts for longer papers and returning customers. All prices include unlimited revisions and plagiarism reports.',
                                    'keywords' => ['academic writing services pricing', 'dissertation writing help cost', 'research paper writing service price', 'custom academic papers cost']
                                ],
                                [
                                    'question' => 'What payment methods do you accept?',
                                    'answer' => 'We accept all major credit cards (Visa, MasterCard, American Express), PayPal, and bank transfers. All payments are processed securely through encrypted channels. We also offer flexible payment plans for larger projects like dissertation writing help and extensive research paper writing service projects.',
                                    'keywords' => ['payment methods', 'secure payment', 'credit cards', 'PayPal']
                                ]
                            ]
                        ]
                    ]
                ],
                'order' => 6,
                'is_active' => true,
            ],

            // Contact Section
            [
                'block_type' => 'contact',
                'block_key' => 'contact_section',
                'content' => [
                    'title' => 'Get In Touch',
                    'subtitle' => 'Have questions about our services? Reach out to our academic consulting team for personalized assistance.',
                    'contact_form' => [
                        'title' => 'Send Us a Message',
                        'fields' => [
                            [
                                'name' => 'full_name',
                                'label' => 'Full Name',
                                'type' => 'text',
                                'placeholder' => 'Your name',
                                'required' => true
                            ],
                            [
                                'name' => 'email',
                                'label' => 'Email Address',
                                'type' => 'email',
                                'placeholder' => 'your@email.com',
                                'required' => true
                            ],
                            [
                                'name' => 'subject',
                                'label' => 'Subject',
                                'type' => 'text',
                                'placeholder' => 'How can we help you?',
                                'required' => true
                            ],
                            [
                                'name' => 'message',
                                'label' => 'Message',
                                'type' => 'textarea',
                                'placeholder' => 'Please describe your academic needs...',
                                'required' => true,
                                'rows' => 4
                            ]
                        ],
                        'submit_text' => 'Send Message'
                    ],
                    'contact_info' => [
                        [
                            'icon' => 'mail',
                            'title' => 'Email Us',
                            'description' => 'Get in touch via email',
                            'value' => 'support@academicscribe.com',
                            'action' => 'mailto:support@academicscribe.com'
                        ],
                        [
                            'icon' => 'phone',
                            'title' => 'Call Us',
                            'description' => 'Speak with our team',
                            'value' => '+1 (555) 123-4567',
                            'action' => 'tel:+15551234567'
                        ],
                        [
                            'icon' => 'message-square',
                            'title' => 'Live Chat',
                            'description' => 'Chat with us online',
                            'value' => 'Available 24/7',
                            'action' => '/chat'
                        ]
                    ],
                    'social_links' => [
                        [
                            'platform' => 'LinkedIn',
                            'url' => 'https://linkedin.com/company/academicscribe',
                            'icon' => 'linkedin'
                        ]
                    ]
                ],
                'order' => 7,
                'is_active' => true,
            ]
        ];

        // SEO data for the homepage
        $seoData = [
            'meta_title' => 'Academic Writing Services | Professional Essay Writers | AcademicScribe',
            'meta_description' => 'Professional academic writing services with expert essay writers. Get dissertation writing help, research papers, and custom assignments from PhD-qualified writers. 98% success rate, 24/7 support.',
            'meta_keywords' => 'professional essay writers, dissertation writing help, research paper writing service, custom academic papers, academic writing services, PhD writers, essay writing help, thesis writing service',
            'canonical_url' => url('/'),
            'robots' => 'index, follow',
            'language' => 'en-US',
            'og_title' => 'Academic Writing Services | Professional Essay Writers | AcademicScribe',
            'og_description' => 'Professional academic writing services with expert essay writers. Get dissertation writing help, research papers, and custom assignments from PhD-qualified writers. 98% success rate, 24/7 support.',
            'og_image' => '/images/hero-academic-writers.jpg',
            'og_type' => 'website',
            'og_url' => url('/'),
            'og_site_name' => 'AcademicScribe',
            'og_locale' => 'en_US',
            'twitter_card' => 'summary_large_image',
            'twitter_site' => '@AcademicScribe',
            'twitter_creator' => '@AcademicScribe',
            'twitter_title' => 'Academic Writing Services | Professional Essay Writers',
            'twitter_description' => 'Professional academic writing services with expert essay writers. Get dissertation writing help, research papers, and custom assignments from PhD-qualified writers.',
            'twitter_image' => '/images/hero-academic-writers.jpg',
            'twitter_image_alt' => 'Professional essay writers providing dissertation writing help',
            'structured_data' => [
                'service' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'Service',
                    'name' => 'Academic Writing Services',
                    'description' => 'Professional academic writing services with expert essay writers providing dissertation writing help, research papers, and custom assignments.',
                    'provider' => [
                        '@type' => 'Organization',
                        'name' => 'AcademicScribe',
                        'url' => url('/'),
                        'logo' => url('/images/logo.png')
                    ],
                    'areaServed' => 'Worldwide',
                    'serviceType' => 'Academic Writing',
                    'offers' => [
                        '@type' => 'Offer',
                        'description' => 'Professional essay writing, dissertation writing help, research paper writing service',
                        'priceRange' => '$10-25 per page'
                    ]
                ],
                'organization' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'Organization',
                    'name' => 'AcademicScribe',
                    'url' => url('/'),
                    'logo' => url('/images/logo.png'),
                    'description' => 'Professional academic writing services with expert essay writers providing dissertation writing help, research papers, and custom assignments.',
                    'contactPoint' => [
                        '@type' => 'ContactPoint',
                        'telephone' => '+1-555-123-4567',
                        'contactType' => 'customer service',
                        'availableLanguage' => 'English'
                    ],
                    'sameAs' => [
                        'https://linkedin.com/company/academicscribe'
                    ]
                ],
                'website' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'WebSite',
                    'name' => 'AcademicScribe',
                    'url' => url('/'),
                    'description' => 'Professional academic writing services with expert essay writers providing dissertation writing help, research papers, and custom assignments.',
                    'potentialAction' => [
                        '@type' => 'SearchAction',
                        'target' => url('/search?q={search_term_string}'),
                        'query-input' => 'required name=search_term_string'
                    ]
                ],
                'breadcrumb' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'BreadcrumbList',
                    'itemListElement' => [
                        [
                            '@type' => 'ListItem',
                            'position' => 1,
                            'name' => 'Home',
                            'item' => url('/')
                        ]
                    ]
                ]
            ]
        ];

        // Create the homepage
        $this->pageService->createPage(
            $homepageData,
            $contentBlocks,
            $seoData
        );

        $this->command->info('Homepage content created successfully!');
    }
}

