<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedGuaranteesPageComplete extends Seeder
{
    public function run()
    {
        // Delete existing guarantees page if it exists
        $existingPage = Page::where('slug', 'guarantees')->first();
        if ($existingPage) {
            $existingPage->contentBlocks()->delete();
            $existingPage->seo()->delete();
            $existingPage->delete();
        }

        // Create the Guarantees page
        $page = Page::create([
            'title' => 'Our Guarantees - Academic Scribe',
            'slug' => 'guarantees',
            'page_type' => 'landing',
            'status' => 'published',
            'template' => 'default',
            'seo_priority' => 85,
            'published_at' => now(),
        ]);

        // Create SEO data (EXACT from original)
        PageSeo::create([
            'page_id' => $page->id,
            'meta_title' => 'Quality Guarantees | 100% Plagiarism-Free, Money-Back, Free Revisions | Academic Scribe',
            'meta_description' => 'Quality guarantees for essay writing, research papers, dissertations. 100% plagiarism-free guarantee, money-back guarantee, free unlimited revisions, on-time delivery, expert writers, privacy protection.',
            'meta_keywords' => 'plagiarism-free guarantee, money-back guarantee, free revisions guarantee, on-time delivery guarantee, expert writer guarantee, privacy guarantee, quality assurance, academic writing guarantees, essay writing guarantee, research paper guarantee, dissertation guarantee',
            'canonical_url' => 'https://academicscribe.com/guarantees',
            'robots' => 'index, follow',
            'og_title' => 'Quality Guarantees | 100% Plagiarism-Free, Money-Back, Free Revisions',
            'og_description' => 'Comprehensive quality guarantees for all academic writing services. Plagiarism-free, money-back, free revisions, on-time delivery guaranteed.',
            'og_image' => '/images/quality-guarantees.jpg',
            'og_type' => 'website',
            'twitter_card' => 'summary_large_image',
            'twitter_title' => 'Quality Guarantees | 100% Plagiarism-Free, Money-Back, Free Revisions',
            'twitter_description' => 'Comprehensive quality guarantees for academic writing services. Risk-free ordering with multiple guarantees.',
            'twitter_image' => '/images/quality-guarantees.jpg',
        ]);

        // Block 1: Hero Section (EXACT text from original)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantees_hero',
            'block_key' => 'guarantees_hero',
            'order' => 1,
            'is_active' => true,
            'content' => [
                'title' => 'Quality Guarantees You Can Trust',
                'subtitle' => '',
                'description' => '100% plagiarism-free guarantee, money-back guarantee, free unlimited revisions, and on-time delivery for all essay writing, research papers, and dissertation services.',
                'primaryButtonText' => 'Order Risk-Free Now',
                'primaryButtonLink' => '/place-order',
                'secondaryButtonText' => 'View All Services',
                'secondaryButtonLink' => '/services',
            ]
        ]);

        // Block 2: Main Guarantees Grid (EXACT from original - all 6 guarantees)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'main_guarantees',
            'block_key' => 'main_guarantees',
            'order' => 2,
            'is_active' => true,
            'content' => [
                'title' => 'Our Comprehensive Quality Guarantees',
                'description' => 'Risk-free academic writing services with multiple guarantees for your peace of mind',
                'guarantees' => [
                    [
                        'icon' => '🔒',
                        'title' => '100% Plagiarism-Free Guarantee',
                        'description' => 'Every paper is written from scratch with original content. We provide free plagiarism reports with every order.',
                        'features' => [
                            'Original content written from scratch',
                            'Free Turnitin plagiarism report',
                            'Multiple plagiarism detection tools',
                            'Zero tolerance for copied content',
                        ],
                        'link' => '/services/essay-writing',
                        'linkText' => 'Get Original Essays',
                    ],
                    [
                        'icon' => '💰',
                        'title' => 'Money-Back Guarantee',
                        'description' => 'Not satisfied with your paper? Get your money back. We offer full refunds for unsatisfactory work.',
                        'features' => [
                            'Full refund if not satisfied',
                            'Partial refunds for late delivery',
                            'No questions asked policy',
                            'Quick refund processing',
                        ],
                        'link' => '/services/research-papers',
                        'linkText' => 'Risk-Free Research Papers',
                    ],
                    [
                        'icon' => '🔄',
                        'title' => 'Free Unlimited Revisions',
                        'description' => 'We revise your paper until you\'re completely satisfied. Free revisions within 30 days of delivery.',
                        'features' => [
                            'Unlimited revisions for 30 days',
                            'Quick revision turnaround',
                            'No additional charges',
                            'Direct communication with writer',
                        ],
                        'link' => '/services/assignments',
                        'linkText' => 'Get Perfect Assignments',
                    ],
                    [
                        'icon' => '⏰',
                        'title' => 'On-Time Delivery Guarantee',
                        'description' => 'We deliver your paper on time, every time. Late delivery results in automatic compensation.',
                        'features' => [
                            'Guaranteed on-time delivery',
                            'Compensation for late delivery',
                            'Progress tracking available',
                            'Rush orders accepted',
                        ],
                        'link' => '/services/dissertation-writing',
                        'linkText' => 'Timely Dissertation Help',
                    ],
                    [
                        'icon' => '🎓',
                        'title' => 'Expert Writer Guarantee',
                        'description' => 'Your paper is written by qualified experts in your field with advanced degrees and experience.',
                        'features' => [
                            'PhD and Masters level writers',
                            'Subject matter experts',
                            'Native English speakers',
                            'Verified academic credentials',
                        ],
                        'link' => '/services/thesis-proposals',
                        'linkText' => 'Expert Thesis Writing',
                    ],
                    [
                        'icon' => '🔐',
                        'title' => 'Privacy & Confidentiality',
                        'description' => 'Your personal information and order details are kept strictly confidential and secure.',
                        'features' => [
                            'SSL encrypted transactions',
                            'Anonymous communication',
                            'No data sharing with third parties',
                            'Secure payment processing',
                        ],
                        'link' => '/services/case-studies',
                        'linkText' => 'Confidential Case Studies',
                    ],
                ]
            ]
        ]);

        // Block 3: Quality Standards (EXACT from original)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'quality_standards',
            'block_key' => 'quality_standards',
            'order' => 3,
            'is_active' => true,
            'content' => [
                'title' => 'Our Quality Standards & Assurance Process',
                'description' => 'Rigorous quality control ensures every paper meets the highest academic standards',
                'standards' => [
                    [
                        'title' => 'Academic Writing Standards',
                        'description' => 'All papers meet strict academic writing standards with proper formatting and citations.',
                        'link' => '/services/literature-reviews',
                        'linkText' => 'Professional Literature Reviews',
                    ],
                    [
                        'title' => 'Quality Assurance Process',
                        'description' => 'Multi-step quality check including editing, proofreading, and plagiarism detection.',
                        'link' => '/services/essay-writing',
                        'linkText' => 'Quality Essay Writing',
                    ],
                    [
                        'title' => 'Customer Satisfaction',
                        'description' => '98% customer satisfaction rate with thousands of successful orders completed.',
                        'link' => '/services/research-papers',
                        'linkText' => 'Satisfied Research Clients',
                    ],
                    [
                        'title' => '24/7 Customer Support',
                        'description' => 'Round-the-clock customer support to address any concerns or questions.',
                        'link' => '/services/assignments',
                        'linkText' => 'Supported Assignment Help',
                    ],
                ]
            ]
        ]);

        // Block 4: How Our Guarantees Work (NEW - from original)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantee_process',
            'block_key' => 'guarantee_process',
            'order' => 4,
            'is_active' => true,
            'content' => [
                'title' => 'How Our Academic Writing Guarantees Work',
                'description' => 'Simple, transparent process to ensure your satisfaction with every order',
                'steps' => [
                    [
                        'number' => 1,
                        'title' => 'Place Your Order',
                        'description' => 'Submit your requirements and our guarantees automatically apply to your order.',
                        'link' => '/services/essay-writing',
                        'linkText' => 'Start with Essay Writing',
                    ],
                    [
                        'number' => 2,
                        'title' => 'Quality Assurance',
                        'description' => 'Expert writers create original content with multi-step quality checks.',
                        'link' => '/services/research-papers',
                        'linkText' => 'Quality Research Papers',
                    ],
                    [
                        'number' => 3,
                        'title' => 'Guaranteed Satisfaction',
                        'description' => 'Free revisions, refunds, or compensation if guarantees aren\'t met.',
                        'link' => '/services/dissertation-writing',
                        'linkText' => 'Guaranteed Dissertations',
                    ],
                ]
            ]
        ]);

        // Block 5: Service-Specific Guarantees (NEW - from original, all 7 services)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'service_guarantees',
            'block_key' => 'service_guarantees',
            'order' => 5,
            'is_active' => true,
            'content' => [
                'title' => 'Guarantees for All Academic Writing Services',
                'description' => 'Every service comes with our comprehensive guarantee package',
                'services' => [
                    [
                        'title' => 'Essay Writing Guarantees',
                        'features' => [
                            '100% original essay content',
                            'Perfect grammar and formatting',
                            'Proper citation styles (APA, MLA, Chicago)',
                            'Free plagiarism report included',
                        ],
                        'link' => '/services/essay-writing',
                        'linkText' => 'Get Guaranteed Essays',
                    ],
                    [
                        'title' => 'Research Paper Guarantees',
                        'features' => [
                            'Thorough research and analysis',
                            'Credible academic sources',
                            'Proper methodology and findings',
                            'Expert-level writing quality',
                        ],
                        'link' => '/services/research-papers',
                        'linkText' => 'Get Guaranteed Research',
                    ],
                    [
                        'title' => 'Dissertation Guarantees',
                        'features' => [
                            'PhD-level writing expertise',
                            'Comprehensive literature review',
                            'Original research contribution',
                            'Chapter-by-chapter approval',
                        ],
                        'link' => '/services/dissertation-writing',
                        'linkText' => 'Get Guaranteed Dissertation',
                    ],
                    [
                        'title' => 'Assignment Guarantees',
                        'features' => [
                            'Exact requirement compliance',
                            'Subject-specific expertise',
                            'Timely submission guarantee',
                            'Grade improvement assurance',
                        ],
                        'link' => '/services/assignments',
                        'linkText' => 'Get Guaranteed Assignments',
                    ],
                    [
                        'title' => 'Case Study Guarantees',
                        'features' => [
                            'Real-world application focus',
                            'Industry-specific analysis',
                            'Professional presentation',
                            'Actionable recommendations',
                        ],
                        'link' => '/services/case-studies',
                        'linkText' => 'Get Guaranteed Case Studies',
                    ],
                    [
                        'title' => 'Literature Review Guarantees',
                        'features' => [
                            'Comprehensive source coverage',
                            'Critical analysis and synthesis',
                            'Current and relevant sources',
                            'Proper academic structure',
                        ],
                        'link' => '/services/literature-reviews',
                        'linkText' => 'Get Guaranteed Reviews',
                    ],
                    [
                        'title' => 'Thesis Proposal Guarantees',
                        'features' => [
                            'Clear research question',
                            'Detailed methodology',
                            'Comprehensive literature review',
                            'Approval-ready format',
                        ],
                        'link' => '/services/thesis-proposals',
                        'linkText' => 'Get Guaranteed Proposals',
                    ],
                ]
            ]
        ]);

        // Block 6: Testimonials (EXACT from original - all 6)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantees_testimonials',
            'block_key' => 'guarantees_testimonials',
            'order' => 6,
            'is_active' => true,
            'content' => [
                'title' => 'What Our Customers Say About Our Guarantees',
                'description' => 'Real experiences from students who benefited from our quality guarantees',
                'testimonials' => [
                    [
                        'text' => 'The plagiarism-free guarantee gave me confidence. My essay was 100% original with a detailed plagiarism report.',
                        'author' => 'Sarah M.',
                        'role' => 'Verified Customer',
                        'rating' => 5,
                        'service' => 'Essay Writing',
                    ],
                    [
                        'text' => 'Money-back guarantee worked perfectly. Got a full refund when the first draft didn\'t meet requirements.',
                        'author' => 'Mike R.',
                        'role' => 'Verified Customer',
                        'rating' => 5,
                        'service' => 'Research Papers',
                    ],
                    [
                        'text' => 'Free revisions guarantee is amazing. They revised my dissertation 3 times until it was perfect.',
                        'author' => 'Lisa K.',
                        'role' => 'Verified Customer',
                        'rating' => 5,
                        'service' => 'Dissertation',
                    ],
                    [
                        'text' => 'On-time delivery guarantee saved my grade. Got my assignment 2 hours before the deadline.',
                        'author' => 'John D.',
                        'role' => 'Verified Customer',
                        'rating' => 5,
                        'service' => 'Assignments',
                    ],
                    [
                        'text' => 'Expert writer guarantee delivered. My thesis proposal was written by a PhD in my field.',
                        'author' => 'Emma T.',
                        'role' => 'Verified Customer',
                        'rating' => 5,
                        'service' => 'Thesis Proposal',
                    ],
                    [
                        'text' => 'Privacy guarantee is real. Complete confidentiality throughout the entire process.',
                        'author' => 'Alex P.',
                        'role' => 'Verified Customer',
                        'rating' => 5,
                        'service' => 'Case Studies',
                    ],
                ]
            ]
        ]);

        // Block 7: FAQs (EXACT from original - all 8 FAQs)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantees_faqs',
            'block_key' => 'guarantees_faqs',
            'order' => 7,
            'is_active' => true,
            'content' => [
                'title' => 'Frequently Asked Questions About Our Guarantees',
                'description' => 'Get answers to common questions about our quality guarantees and policies',
                'faqs' => [
                    [
                        'question' => 'What is your plagiarism-free guarantee for essay writing services?',
                        'answer' => 'Our plagiarism-free guarantee ensures every essay is written from scratch with 100% original content. We provide free Turnitin reports and use multiple plagiarism detection tools to verify originality.',
                        'link' => '/services/essay-writing',
                        'linkText' => 'Learn about our essay writing guarantee',
                    ],
                    [
                        'question' => 'How does your money-back guarantee work for research papers?',
                        'answer' => 'If you\'re not satisfied with your research paper, we offer full refunds. Our money-back guarantee covers quality issues, late delivery, and failure to meet requirements.',
                        'link' => '/services/research-papers',
                        'linkText' => 'Get guaranteed research papers',
                    ],
                    [
                        'question' => 'What does your free revision guarantee include for dissertations?',
                        'answer' => 'Our free revision guarantee includes unlimited revisions for 30 days after delivery. We revise your dissertation until it meets your exact requirements at no extra cost.',
                        'link' => '/services/dissertation-writing',
                        'linkText' => 'Explore dissertation revision guarantee',
                    ],
                    [
                        'question' => 'Do you guarantee on-time delivery for urgent assignments?',
                        'answer' => 'Yes, we guarantee on-time delivery for all assignments, including urgent orders. Late delivery results in automatic compensation or partial refunds.',
                        'link' => '/services/assignments',
                        'linkText' => 'Get timely assignment help',
                    ],
                    [
                        'question' => 'What qualifications do your guaranteed expert writers have?',
                        'answer' => 'Our expert writers hold PhD and Masters degrees in their respective fields. All writers are verified for their academic credentials and writing experience.',
                        'link' => '/services/thesis-proposals',
                        'linkText' => 'Meet our expert thesis writers',
                    ],
                    [
                        'question' => 'How do you guarantee privacy and confidentiality?',
                        'answer' => 'We guarantee complete privacy through SSL encryption, anonymous communication, and strict no-sharing policies. Your personal information is never disclosed to third parties.',
                        'link' => '/services/case-studies',
                        'linkText' => 'Confidential case study writing',
                    ],
                    [
                        'question' => 'What quality standards do you guarantee for literature reviews?',
                        'answer' => 'We guarantee academic writing standards including proper formatting, citations, and thorough research. All literature reviews undergo multi-step quality assurance.',
                        'link' => '/services/literature-reviews',
                        'linkText' => 'Quality literature review guarantee',
                    ],
                    [
                        'question' => 'Do you guarantee customer satisfaction for all services?',
                        'answer' => 'Yes, we guarantee customer satisfaction with a 98% satisfaction rate. We work with you until you\'re completely happy with your paper or provide a full refund.',
                        'link' => '/services',
                        'linkText' => 'Explore all guaranteed services',
                    ],
                ]
            ]
        ]);

        // Block 8: Trust Indicators (NEW - from original)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'trust_indicators',
            'block_key' => 'trust_indicators',
            'order' => 8,
            'is_active' => true,
            'content' => [
                'title' => 'Why Our Guarantees Are Trustworthy',
                'description' => 'Backed by years of experience and thousands of satisfied customers',
                'indicators' => [
                    [
                        'value' => '98%',
                        'label' => 'Customer Satisfaction Rate',
                        'link' => '/services/essay-writing',
                        'linkText' => 'Satisfied Essay Customers',
                    ],
                    [
                        'value' => '15,000+',
                        'label' => 'Successful Orders Completed',
                        'link' => '/services/research-papers',
                        'linkText' => 'Join Successful Students',
                    ],
                    [
                        'value' => '5+ Years',
                        'label' => 'Industry Experience',
                        'link' => '/services/dissertation-writing',
                        'linkText' => 'Experienced Dissertation Help',
                    ],
                    [
                        'value' => '24/7',
                        'label' => 'Customer Support Available',
                        'link' => '/services/assignments',
                        'linkText' => 'Get Assignment Support',
                    ],
                ]
            ]
        ]);

        // Block 9: Guarantee Comparison (NEW - from original)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantee_comparison',
            'block_key' => 'guarantee_comparison',
            'order' => 9,
            'is_active' => true,
            'content' => [
                'title' => 'Compare Our Guarantees with Competitors',
                'description' => 'See why our quality guarantees are the most comprehensive in the industry',
                'features' => [
                    [
                        'name' => '100% Plagiarism-Free',
                        'us' => 'check',
                        'compA' => 'check',
                        'compB' => 'x',
                    ],
                    [
                        'name' => 'Money-Back Guarantee',
                        'us' => 'check',
                        'compA' => 'Limited',
                        'compB' => 'x',
                    ],
                    [
                        'name' => 'Free Unlimited Revisions',
                        'us' => 'check',
                        'compA' => '3 Only',
                        'compB' => '5 Only',
                    ],
                    [
                        'name' => 'On-Time Delivery',
                        'us' => 'check',
                        'compA' => 'check',
                        'compB' => 'No Guarantee',
                    ],
                    [
                        'name' => 'Expert PhD Writers',
                        'us' => 'check',
                        'compA' => 'Some',
                        'compB' => 'Limited',
                    ],
                    [
                        'name' => '24/7 Customer Support',
                        'us' => 'check',
                        'compA' => 'Business Hours',
                        'compB' => 'Limited Hours',
                    ],
                ],
                'ctaText' => 'Choose Superior Guarantees',
                'ctaLink' => '/services',
            ]
        ]);

        // Block 10: Contact Support (NEW - from original)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'contact_support',
            'block_key' => 'contact_support',
            'order' => 10,
            'is_active' => true,
            'content' => [
                'title' => 'Questions About Our Guarantees?',
                'description' => 'Our customer support team is available 24/7 to explain our guarantees and help you place your order',
                'contacts' => [
                    [
                        'title' => 'Call Us',
                        'description' => 'Speak with guarantee experts',
                        'value' => '+1 (800) 123-4567',
                        'link' => 'tel:+1-800-123-4567',
                        'type' => 'link',
                    ],
                    [
                        'title' => 'Email Us',
                        'description' => 'Get detailed guarantee information',
                        'value' => 'info@academicscribe.com',
                        'link' => 'mailto:info@academicscribe.com',
                        'type' => 'link',
                    ],
                    [
                        'title' => 'Live Chat',
                        'description' => 'Chat about guarantees now',
                        'value' => 'Start Live Chat',
                        'link' => '#',
                        'type' => 'button',
                    ],
                ],
                'notice' => [
                    'icon' => '💡',
                    'title' => 'Guarantee Activation',
                    'description' => 'All guarantees are automatically activated when you place an order. No additional steps required - your satisfaction is our priority from day one.',
                ],
            ]
        ]);

        // Block 11: Service Links Footer (NEW - from original, all 7 services)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'service_links',
            'block_key' => 'service_links',
            'order' => 11,
            'is_active' => true,
            'content' => [
                'title' => 'All Services Come with Our Complete Guarantee Package',
                'description' => 'Every service includes plagiarism-free guarantee, money-back guarantee, free revisions, and more',
                'services' => [
                    ['icon' => '📝', 'name' => 'Essay Writing', 'link' => '/services/essay-writing'],
                    ['icon' => '🔬', 'name' => 'Research Papers', 'link' => '/services/research-papers'],
                    ['icon' => '🎓', 'name' => 'Dissertations', 'link' => '/services/dissertation-writing'],
                    ['icon' => '📚', 'name' => 'Assignments', 'link' => '/services/assignments'],
                    ['icon' => '💼', 'name' => 'Case Studies', 'link' => '/services/case-studies'],
                    ['icon' => '📖', 'name' => 'Literature Reviews', 'link' => '/services/literature-reviews'],
                    ['icon' => '📋', 'name' => 'Thesis Proposals', 'link' => '/services/thesis-proposals'],
                ],
            ]
        ]);

        // Block 12: Final CTA
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantees_cta',
            'block_key' => 'guarantees_cta',
            'order' => 12,
            'is_active' => true,
            'content' => [
                'title' => 'Ready to Experience Our Quality Guarantees?',
                'description' => 'Join thousands of satisfied students who trust our comprehensive guarantees. Order now with complete confidence and peace of mind.',
                'primaryButtonText' => 'Order Guaranteed Essays',
                'primaryButtonLink' => '/services/essay-writing',
                'secondaryButtonText' => 'Get Research Papers',
                'secondaryButtonLink' => '/services/research-papers',
            ]
        ]);

        $this->command->info('✅ Complete Guarantees page created with ALL content blocks!');
        $this->command->info('   - 12 content blocks covering all sections from original');
        $this->command->info('   - Exact text and punctuation for SEO retention');
        $this->command->info('   - All 6 guarantees, 8 FAQs, 6 testimonials, 7 services');
    }
}
