<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;

class SeedHomepageAbout extends Seeder
{
    public function run(): void
    {
        $page = Page::where('slug', 'homepage')->first();

        if (!$page) {
            $page = Page::create([
                'slug' => 'homepage',
                'title' => 'Homepage',
                'page_type' => 'homepage',
                'status' => 'published',
            ]);
        }

        $content = [
            'title' => 'About Academic Scribe',
            'description' => 'We are a leading <a href="https://academicscribe.com/about">academic writing company</a>  providing professional academic writing services to students worldwide. Our expert essay writers and academic writing team deliver custom assignments, dissertaions research papers, and essays with guaranteed quality and originality.',
            'mission_title' => 'Our Mission',
            'mission_description' => 'To provide exceptional academic writing services that empower students worldwide. As one of the leading websites that write assignments and essays for students online, we maintain the highest standards of quality, originality, and academic integrity in every project.',
            'features' => [
                [
                    'title' => '<a href="https://academicscribe.com/writers">Expert Writers</a>',
                    'description' => 'PhD-qualified professionals with extensive academic experience',
                ],
                [
                    'title' => 'Quality Assurance',
                    'description' => 'Rigorous quality control and plagiarism checking processes',
                ],
                [
                    'title' => '24/7 Support',
                    'description' => 'Round-the-clock customer support and assistance',
                ],
                [
                    'title' => 'On-Time Delivery',
                    'description' => 'Guaranteed delivery within your specified deadline',
                ],
            ],
            'about_image' => '/images/about-story.jpg',
            'about_image_alt' => 'Academic Scribe team - Professional academic writers and support staff',
        ];

        PageContent::updateOrCreate(
            [
                'page_id' => $page->id,
                'block_type' => 'about',
                'block_key' => 'about_main',
            ],
            [
                'content' => $content,
                'order' => 2,
                'is_active' => true,
            ]
        );
    }
}





