<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;

class SeedHomepageCTA extends Seeder
{
    public function run(): void
    {
        $page = Page::where('slug', 'homepage')->first();
        if (!$page) {
            $page = Page::create([
                'slug' => 'homepage',
                'title' => 'Homepage',
                'page_type' => 'homepage',
                'status' => 'published',
            ]);
        }

        $payload = [
            'title' => 'Ready to Get Started?',
            'description' => 'Our team of expert writers is ready to help you achieve academic excellence',
            'background_color' => 'blue',
            'benefits' => [
                [
                    'text' => 'Professional writers with advanced degrees',
                    'icon' => 'Award',
                ],
                [
                    'text' => 'On-time delivery guaranteed',
                    'icon' => 'Clock',
                ],
                [
                    'text' => '100% original, plagiarism-free papers',
                    'icon' => 'CheckCircle',
                ],
            ],
            'primary_button_text' => 'Place an Order',
            'primary_button_link' => '/place-order',
            'secondary_button_text' => 'Contact Us',
            'secondary_button_link' => '#contact',
        ];

        PageContent::updateOrCreate(
            [
                'page_id' => $page->id,
                'block_type' => 'cta',
                'block_key' => 'cta_main',
            ],
            [
                'content' => $payload,
                'order' => 8,
                'is_active' => true,
            ]
        );
    }
}

