<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;

class SeedHomepageContact extends Seeder
{
    public function run(): void
    {
        $page = Page::where('slug', 'homepage')->first();
        if (!$page) {
            $page = Page::create([
                'slug' => 'homepage',
                'title' => 'Homepage',
                'page_type' => 'homepage',
                'status' => 'published',
            ]);
        }

        $payload = [
            'title' => 'Get In Touch',
            'subtitle' => 'Have questions about our services? Reach out to our academic consulting team for personalized assistance.',
        ];

        PageContent::updateOrCreate(
            [
                'page_id' => $page->id,
                'block_type' => 'contact',
                'block_key' => 'contact_main',
            ],
            [
                'content' => $payload,
                'order' => 7,
                'is_active' => true,
            ]
        );
    }
}

