<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;

class SeedHomepageHero extends Seeder
{
    public function run(): void
    {
        $page = Page::where('slug', 'homepage')->first();

        if (!$page) {
            $page = Page::create([
                'slug' => 'homepage',
                'title' => 'Homepage',
                'page_type' => 'homepage',
                'status' => 'published',
            ]);
        }

        $data = [
            'headlinePrimary' => 'Professional',
            'headlineHighlight' => 'Academic Writing Services',
            'headlineSuffix' => 'for Students Worldwide',
            'trustText' => 'Trusted by 10,000+ students worldwide',
            'paragraph' => 'Leading academic writing company providing expert essay writers and dissertation writing help. Our professional academic writing service delivers custom assignments, research papers, and essays for students worldwide with guaranteed quality and originality.',
            'bullet1' => 'Trusted academic writing company',
            'bullet2' => '100% original content',
            'bullet3' => '24/7 customer support',
            'bullet4' => 'On-time delivery guaranteed',
            'ctaPrimaryText' => 'Get Started Now',
            'ctaPrimaryHref' => '/place-order',
            'ctaSecondaryText' => 'View Services',
            'ctaSecondaryHref' => '/services',
            'stat1Value' => '10K+',
            'stat1Label' => 'Happy Students',
            'stat2Value' => '98%',
            'stat2Label' => 'Success Rate',
            'stat3Value' => '24/7',
            'stat3Label' => 'Support',
            'heroImage' => '/images/hero-academic-writers.jpg',
            'heroAlt' => 'Professional essay writers providing dissertation writing help and research paper writing service for custom academic papers - Academic writing services team',
        ];

        PageContent::updateOrCreate(
            [
                'page_id' => $page->id,
                'block_type' => 'hero',
                'block_key' => 'hero_main',
            ],
            [
                'content' => $data,
                'order' => 1,
                'is_active' => true,
            ]
        );
    }
}





