<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;

class SeedHomepageServices extends Seeder
{
    public function run(): void
    {
        $page = Page::where('slug', 'homepage')->first();
        if (!$page) {
            $page = Page::create([
                'slug' => 'homepage',
                'title' => 'Homepage',
                'page_type' => 'homepage',
                'status' => 'published',
            ]);
        }

        $services = [
            [
                'name' => 'Essay Writing',
                'description' => 'Professional essay writing service with expert writers specializing in all academic levels and subjects.',
                'icon' => 'file-text',
                'href' => '/services/essay-writing',
                'features' => ['All Academic Levels','24/7 Support','Plagiarism-Free'],
                'color' => 'blue',
            ],
            [
                'name' => 'Research Papers',
                'description' => 'Comprehensive research paper writing service with thorough analysis and proper citations.',
                'icon' => 'search',
                'href' => '/services/research-papers',
                'features' => ['In-depth Research','Proper Citations','Quality Assurance'],
                'color' => 'green',
            ],
            [
                'name' => 'Dissertation Writing',
                'description' => 'Expert dissertation writing help from PhD-qualified writers with extensive research experience.',
                'icon' => 'graduation-cap',
                'href' => '/services/dissertation-writing',
                'features' => ['PhD Writers','Original Research','Timely Delivery'],
                'color' => 'purple',
            ],
            [
                'name' => 'Assignments',
                'description' => 'Custom assignment writing service covering all subjects and academic requirements.',
                'icon' => 'clipboard-list',
                'href' => '/services/assignments',
                'features' => ['All Subjects','Custom Solutions','Fast Turnaround'],
                'color' => 'orange',
            ],
            [
                'name' => 'Case Studies',
                'description' => 'Professional case study analysis and writing service with detailed insights and solutions.',
                'icon' => 'bar-chart-3',
                'href' => '/services/case-studies',
                'features' => ['Detailed Analysis','Real Examples','Expert Insights'],
                'color' => 'indigo',
            ],
            [
                'name' => 'Literature Reviews',
                'description' => 'Comprehensive literature review writing service with systematic analysis and synthesis.',
                'icon' => 'book-open',
                'href' => '/services/literature-reviews',
                'features' => ['Systematic Review','Critical Analysis','Academic Standards'],
                'color' => 'teal',
            ],
            [
                'name' => 'Thesis Proposals',
                'description' => 'Expert thesis proposal writing service with clear methodology and research objectives.',
                'icon' => 'target',
                'href' => '/services/thesis-proposals',
                'features' => ['Clear Methodology','Research Objectives','Academic Format'],
                'color' => 'pink',
            ],
            [
                'name' => 'Personal Statements',
                'description' => 'Compelling personal statement writing service for university applications and scholarships.',
                'icon' => 'user',
                'href' => '/services/personal-statements',
                'features' => ['Compelling Narrative','Application Focus','Success Stories'],
                'color' => 'rose',
            ],
            [
                'name' => 'Programming Assignments',
                'description' => 'Expert programming assignment help with clean code, documentation, and testing.',
                'icon' => 'code',
                'href' => '/services/programming-assignments',
                'features' => ['Clean Code','Documentation','Testing Included'],
                'color' => 'cyan',
            ],
        ];

        $payload = [
            'title' => 'Our Academic Writing Services',
            'subtitle' => 'Professional academic writing services tailored to meet your specific needs. Our expert writers deliver high-quality, original content across all academic disciplines.',
            'services' => $services,
        ];

        PageContent::updateOrCreate(
            [
                'page_id' => $page->id,
                'block_type' => 'services',
                'block_key' => 'services_main',
            ],
            [
                'content' => $payload,
                'order' => 3,
                'is_active' => true,
            ]
        );
    }
}





