<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;

class SeedHomepageStats extends Seeder
{
    public function run(): void
    {
        $page = Page::where('slug', 'homepage')->first();
        if (!$page) {
            $page = Page::create([
                'slug' => 'homepage',
                'title' => 'Homepage',
                'page_type' => 'homepage',
                'status' => 'published',
            ]);
        }

        $payload = [
            'title' => 'Our Professional Essay Writers by the Numbers',
            'subtitle' => 'The qualified professionals behind our exceptional custom academic papers',
            'main_stats' => [
                [
                    'number' => '98%',
                    'label' => 'Client Satisfaction Rate',
                    'description' => 'Students recommend our academic writing services',
                    'icon' => 'heart',
                    'color' => 'red',
                    'detail' => 'Based on 1,200+ verified reviews',
                ],
                [
                    'number' => '1,250+',
                    'label' => 'Completed Academic Projects',
                    'description' => 'Successfully delivered custom academic papers',
                    'icon' => 'book-open',
                    'color' => 'blue',
                    'detail' => 'Across all academic levels',
                ],
                [
                    'number' => '180+',
                    'label' => 'Professional Essay Writers',
                    'description' => 'PhD and Master\'s level academic experts',
                    'icon' => 'users',
                    'color' => 'green',
                    'detail' => 'Rigorously vetted and qualified',
                ],
                [
                    'number' => '35+',
                    'label' => 'Academic Disciplines Covered',
                    'description' => 'Comprehensive subject matter expertise',
                    'icon' => 'target',
                    'color' => 'purple',
                    'detail' => 'From humanities to STEM fields',
                ],
            ],
            'additional_stats' => [
                [
                    'number' => '99.8%',
                    'label' => 'On-Time Delivery',
                    'description' => 'Reliable dissertation writing help',
                    'icon' => 'clock',
                    'color' => 'orange',
                ],
                [
                    'number' => '24/7',
                    'label' => 'Customer Support',
                    'description' => 'Round-the-clock assistance',
                    'icon' => 'globe',
                    'color' => 'blue',
                ],
                [
                    'number' => '100%',
                    'label' => 'Original Content',
                    'description' => 'Plagiarism-free guarantee',
                    'icon' => 'shield',
                    'color' => 'green',
                ],
                [
                    'number' => '5+ Years',
                    'label' => 'Industry Experience',
                    'description' => 'Trusted research paper writing service',
                    'icon' => 'award',
                    'color' => 'yellow',
                ],
                [
                    'number' => '4.9/5',
                    'label' => 'Average Rating',
                    'description' => 'Exceptional service quality',
                    'icon' => 'star',
                    'color' => 'yellow',
                ],
                [
                    'number' => '72 Hours',
                    'label' => 'Fastest Turnaround',
                    'description' => 'Urgent academic writing available',
                    'icon' => 'zap',
                    'color' => 'red',
                ],
            ],
            'writer_stats' => [
                [
                    'label' => 'PhD Holders',
                    'count' => '120+',
                    'description' => 'Doctoral-level expertise for dissertation writing help',
                    'percentage' => 67,
                ],
                [
                    'label' => 'Master\'s Degree Writers',
                    'count' => '60+',
                    'description' => 'Advanced degree professionals for research papers',
                    'percentage' => 33,
                ],
                [
                    'label' => 'Years of Experience',
                    'count' => '8+ Avg',
                    'description' => 'Extensive background in academic writing services',
                    'percentage' => 85,
                ],
                [
                    'label' => 'Published Authors',
                    'count' => '45+',
                    'description' => 'Writers with published academic research',
                    'percentage' => 25,
                ],
            ],
            'expertise_distribution' => [
                [
                    'field' => 'STEM Fields',
                    'count' => '45',
                    'color' => 'blue',
                ],
                [
                    'field' => 'Humanities',
                    'count' => '38',
                    'color' => 'green',
                ],
                [
                    'field' => 'Business',
                    'count' => '32',
                    'color' => 'purple',
                ],
                [
                    'field' => 'Social Sciences',
                    'count' => '28',
                    'color' => 'orange',
                ],
                [
                    'field' => 'Health Sciences',
                    'count' => '25',
                    'color' => 'red',
                ],
                [
                    'field' => 'Education',
                    'count' => '22',
                    'color' => 'indigo',
                ],
            ],
        ];

        PageContent::updateOrCreate(
            [
                'page_id' => $page->id,
                'block_type' => 'stats',
                'block_key' => 'stats_main',
            ],
            [
                'content' => $payload,
                'order' => 6,
                'is_active' => true,
            ]
        );
    }
}

