<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedReviewsPage extends Seeder
{
    public function run()
    {
        // Create the Reviews page
        $page = Page::create([
            'title' => 'Customer Reviews - Academic Scribe',
            'slug' => 'reviews',
            'page_type' => 'landing',
            'status' => 'published',
            'template' => 'default',
            'seo_priority' => 88,
            'published_at' => now(),
        ]);

        // Create SEO data
        PageSeo::create([
            'page_id' => $page->id,
            'meta_title' => 'Customer Reviews & Testimonials - Academic Scribe | 4.9/5 Rating',
            'meta_description' => 'Read 2,847+ verified customer reviews of Academic Scribe. 4.9/5 average rating with 98% satisfaction. See what students say about our essay writing, research papers, dissertations, and assignment help services.',
            'meta_keywords' => 'academic scribe reviews, customer testimonials, essay writing reviews, dissertation reviews, student feedback, academic writing service reviews, verified reviews',
            'canonical_url' => 'https://academicscribe.com/reviews',
            'robots' => 'index, follow',
            'og_title' => 'Customer Reviews - 4.9/5 Rating | 2,847+ Verified Reviews',
            'og_description' => 'See why 2,847+ students trust Academic Scribe. Read verified reviews about our essay writing, research papers, dissertations, and assignment help services. 98% satisfaction rate.',
            'og_image' => 'https://academicscribe.com/images/reviews-og.jpg',
            'twitter_card' => 'summary_large_image',
            'twitter_title' => 'Academic Scribe Reviews - 4.9/5 Stars from 2,847+ Students',
            'twitter_description' => 'Verified customer reviews and testimonials. See why students trust our academic writing services.',
            'structured_data' => [
                'webpage' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'WebPage',
                    'name' => 'Customer Reviews - Academic Scribe',
                    'description' => 'Verified customer reviews and testimonials for Academic Scribe academic writing services',
                    'url' => 'https://academicscribe.com/reviews'
                ]
            ]
        ]);

        // Content Block 1: Hero
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'hero',
            'block_key' => 'reviews_hero',
            'order' => 1,
            'is_active' => true,
            'content' => [
                'title' => 'Customer Reviews & Testimonials',
                'subtitle' => 'See What Our Students Say',
                'description' => 'Read <strong>verified reviews</strong> from thousands of satisfied students who have used our academic writing services. Real feedback from real students.'
            ]
        ]);

        // Content Block 2: Review Stats
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'review_stats',
            'block_key' => 'review_statistics',
            'order' => 2,
            'is_active' => true,
            'content' => [
                'totalReviews' => 2847,
                'averageRating' => 4.9,
                'fiveStars' => 2654,
                'fourStars' => 156,
                'threeStars' => 28,
                'twoStars' => 6,
                'oneStars' => 3,
                'verifiedReviews' => 2847,
            ]
        ]);

        // Content Block 3: Service Filters
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'service_filters',
            'block_key' => 'review_filters',
            'order' => 3,
            'is_active' => true,
            'content' => [
                'filters' => [
                    ['value' => 'all', 'label' => 'All Services', 'count' => 2847],
                    ['value' => 'essay-writing', 'label' => 'Essay Writing Reviews', 'count' => 1245],
                    ['value' => 'research-papers', 'label' => 'Research Paper Reviews', 'count' => 687],
                    ['value' => 'dissertation-writing', 'label' => 'Dissertation Reviews', 'count' => 423],
                    ['value' => 'assignments', 'label' => 'Assignment Help Reviews', 'count' => 298],
                    ['value' => 'case-studies', 'label' => 'Case Study Reviews', 'count' => 134],
                    ['value' => 'literature-reviews', 'label' => 'Literature Review Reviews', 'count' => 60],
                ]
            ]
        ]);

        // Content Block 4: Featured Reviews (sample of top reviews)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'reviews_list',
            'block_key' => 'featured_reviews',
            'order' => 4,
            'is_active' => true,
            'content' => [
                'title' => 'Featured Customer Reviews',
                'reviews' => [
                    [
                        'id' => 1,
                        'name' => 'Sarah Johnson',
                        'service' => 'Essay Writing',
                        'serviceSlug' => 'essay-writing',
                        'rating' => 5,
                        'title' => 'Outstanding Essay Writing Service - Highly Recommended!',
                        'review' => 'Exceptional essay writing service! The quality exceeded my expectations. My writer delivered a perfectly structured argumentative essay with impeccable grammar and compelling arguments. The plagiarism report showed 100% originality. Customer support was responsive throughout the process. Definitely using this service again for future essays.',
                        'date' => '2024-01-15',
                        'verified' => true,
                        'helpful' => 47,
                        'course' => 'English Literature',
                        'university' => 'Harvard University',
                        'grade' => 'A+',
                        'orderType' => 'Argumentative Essay',
                    ],
                    [
                        'id' => 2,
                        'name' => 'Michael Chen',
                        'service' => 'Research Papers',
                        'serviceSlug' => 'research-papers',
                        'rating' => 5,
                        'title' => 'Excellent Research Paper Quality - Professional Writers',
                        'review' => 'Amazing research paper service! The writer demonstrated deep understanding of my topic and provided comprehensive analysis with credible sources. The methodology was sound and the findings were well-presented. Received my psychology research paper on time with free revisions. The quality was PhD-level work. Highly satisfied with the results.',
                        'date' => '2024-01-12',
                        'verified' => true,
                        'helpful' => 52,
                        'course' => 'Psychology',
                        'university' => 'Stanford University',
                        'grade' => 'A',
                        'orderType' => 'Research Paper',
                    ],
                    [
                        'id' => 3,
                        'name' => 'Emma Rodriguez',
                        'service' => 'Dissertation Writing',
                        'serviceSlug' => 'dissertation-writing',
                        'rating' => 5,
                        'title' => 'Professional Dissertation Help - Exceeded Expectations',
                        'review' => 'Outstanding dissertation writing service! My PhD dissertation was handled with utmost professionalism. The writer had expertise in my field and provided excellent literature review, methodology, and analysis chapters. The work was original, well-researched, and properly formatted. Customer service was excellent throughout the lengthy process. Worth every penny!',
                        'date' => '2024-01-10',
                        'verified' => true,
                        'helpful' => 89,
                        'course' => 'Business Administration',
                        'university' => 'MIT',
                        'grade' => 'A+',
                        'orderType' => 'PhD Dissertation',
                    ],
                ]
            ]
        ]);

        // Content Block 5: CTA
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'cta',
            'block_key' => 'reviews_cta',
            'order' => 5,
            'is_active' => true,
            'content' => [
                'title' => 'Ready to Join Our Satisfied Customers?',
                'description' => 'Join <strong>2,847+ successful students</strong> who have achieved academic excellence with our professional writing services. Experience the quality that earns us a <strong>4.9/5 rating</strong>.',
                'primaryButtonText' => 'Place Your Order',
                'primaryButtonLink' => '/place-order',
                'secondaryButtonText' => 'View All Services',
                'secondaryButtonLink' => '/services',
                'bgColor' => 'blue',
            ]
        ]);

        echo "✅ Reviews page seeded successfully!\n";
        echo "   - Page: {$page->title}\n";
        echo "   - Slug: /{$page->slug}\n";
        echo "   - SEO: Complete\n";
        echo "   - Content Blocks: 5\n";
        echo "   - Review Stats: Complete\n";
        echo "   - Featured Reviews: 3 samples\n";
    }
}

