<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedServiceResearchPapers extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Upsert the page for Research Papers service
        $page = Page::updateOrCreate(
            ['slug' => 'research-papers'],
            [
                'title' => 'Research Paper Writing Service',
                'page_type' => 'service',
                'status' => 'published',
                'template' => 'Services/ResearchPapers',
                'seo_priority' => 90,
                'published_at' => now(),
            ]
        );

        // Structured data from researchPapers.js
        $structuredData = [
            'service' => [
                '@context' => 'https://schema.org',
                '@type' => 'Service',
                'name' => 'Professional Research Paper Writing Service',
                'description' => 'Expert research paper writing service providing custom research paper help with professional writers, original research, comprehensive analysis, and perfect academic formatting for all educational levels.',
                'provider' => [
                    '@type' => 'Organization',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                    'logo' => 'https://academicscribe.com/images/logo.png',
                    'contactPoint' => [
                        '@type' => 'ContactPoint',
                        'telephone' => '+1-555-123-4567',
                        'contactType' => 'customer service',
                        'availableLanguage' => ['English'],
                        'areaServed' => 'Worldwide',
                    ],
                    'address' => [
                        '@type' => 'PostalAddress',
                        'addressCountry' => 'US',
                        'addressRegion' => 'Global',
                    ],
                    'sameAs' => [
                        'https://facebook.com/academicscribe',
                        'https://twitter.com/academicscribe',
                        'https://linkedin.com/company/academicscribe',
                    ],
                ],
                'serviceType' => 'Academic Writing Service',
                'areaServed' => 'Worldwide',
                'availableChannel' => [
                    '@type' => 'ServiceChannel',
                    'serviceUrl' => 'https://academicscribe.com/services/research-papers',
                    'servicePhone' => '+1-555-123-4567',
                    'availableLanguage' => 'English',
                ],
                'hasOfferCatalog' => [
                    '@type' => 'OfferCatalog',
                    'name' => 'Research Paper Writing Services',
                    'itemListElement' => [
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Custom Research Paper Help',
                                'description' => 'Personalized research paper writing assistance with original research and analysis',
                            ],
                            'price' => 'Starting at $15.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Academic Research Paper Service',
                                'description' => 'Professional research paper writing for all academic disciplines and levels',
                            ],
                            'price' => 'Starting at $15.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Research Paper Writing Assistance',
                                'description' => 'Expert guidance and support for research paper projects with methodology help',
                            ],
                            'price' => 'Starting at $15.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                    ],
                ],
            ],
            'breadcrumb' => [
                '@context' => 'https://schema.org',
                '@type' => 'BreadcrumbList',
                'itemListElement' => [
                    [
                        '@type' => 'ListItem',
                        'position' => 1,
                        'name' => 'Home',
                        'item' => 'https://academicscribe.com',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 2,
                        'name' => 'Services',
                        'item' => 'https://academicscribe.com/services',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 3,
                        'name' => 'Research Paper Writing Service',
                        'item' => 'https://academicscribe.com/services/research-papers',
                    ],
                ],
            ],
            'organization' => [
                '@context' => 'https://schema.org',
                '@type' => 'Organization',
                'name' => 'Academic Scribe',
                'description' => 'Professional academic writing services with expert research paper writers providing custom research paper help and comprehensive academic research support for students worldwide.',
                'url' => 'https://academicscribe.com',
                'logo' => 'https://academicscribe.com/images/logo.png',
                'image' => 'https://academicscribe.com/images/research-paper-writing-service.jpg',
                'contactPoint' => [
                    '@type' => 'ContactPoint',
                    'telephone' => '+1-555-123-4567',
                    'contactType' => 'customer service',
                    'availableLanguage' => ['English'],
                    'areaServed' => 'Worldwide',
                ],
                'address' => [
                    '@type' => 'PostalAddress',
                    'addressCountry' => 'US',
                    'addressRegion' => 'Global',
                ],
                'sameAs' => [
                    'https://facebook.com/academicscribe',
                    'https://twitter.com/academicscribe',
                    'https://linkedin.com/company/academicscribe',
                ],
            ],
            'website' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebSite',
                'name' => 'Academic Scribe - Research Paper Writing Service',
                'description' => 'Professional research paper writers providing custom research paper help and comprehensive academic research writing service for students at all educational levels.',
                'url' => 'https://academicscribe.com/services/research-papers',
                'potentialAction' => [
                    '@type' => 'SearchAction',
                    'target' => 'https://academicscribe.com/search?q={search_term_string}',
                    'query-input' => 'required name=search_term_string',
                ],
            ],
            'webpage' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebPage',
                'name' => 'Professional Research Paper Writing Service | Custom Research Paper Help',
                'description' => 'Expert research paper writing service with professional writers. Get custom research paper help with original research, comprehensive analysis, and guaranteed results.',
                'url' => 'https://academicscribe.com/services/research-papers',
                'isPartOf' => [
                    '@type' => 'WebSite',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                ],
                'about' => [
                    '@type' => 'Service',
                    'name' => 'Research Paper Writing Service',
                ],
                'mainEntity' => [
                    '@type' => 'Service',
                    'name' => 'Professional Research Paper Writing Service',
                ],
            ],
        ];

        // SEO data
        PageSeo::updateOrCreate(
            ['page_id' => $page->id],
            [
                'meta_title' => 'Professional Research Paper Writing Service | Custom Research Paper Help | Academic Scribe',
                'meta_description' => 'Get expert research paper writing service with professional writers. Custom research paper help for all academic levels with original research, perfect citations, and 24/7 support. Order now for guaranteed results!',
                'meta_keywords' => 'research paper writing service, professional research paper writing, custom research paper help, academic research paper service, research paper writers, research paper writing assistance, college research paper help, university research paper service, research paper writing for students, professional academic writing service, research paper help online, custom research papers, academic research writing, research paper writing company, research paper writing experts',
                'canonical_url' => 'https://academicscribe.com/services/research-papers',
                'og_url' => 'https://academicscribe.com/services/research-papers',
                'robots' => 'index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1',
                'language' => 'en-US',
                'structured_data' => $structuredData,
                'twitter_card' => 'summary_large_image',
                'twitter_title' => 'Professional Research Paper Writing Service | Custom Research Paper Help',
                'twitter_description' => 'Expert research paper writing service with professional writers. Get custom research paper help with original research, perfect citations, and guaranteed results.',
                'twitter_image' => 'https://academicscribe.com/images/research-paper-writing-service-twitter.jpg',
                'og_title' => 'Professional Research Paper Writing Service | Custom Research Paper Help',
                'og_description' => 'Expert research paper writing service with professional writers. Get custom research paper help for all academic levels with original research and comprehensive analysis. Trusted by 10,000+ students worldwide.',
                'og_image' => 'https://academicscribe.com/images/research-paper-writing-service-og.jpg',
                'og_type' => 'website',
            ]
        );

        // Content blocks
        $blocks = [
            [
                'block_type' => 'service_hero',
                'block_key' => 'research_paper_hero',
                'order' => 1,
                'content' => [
                    'title' => 'Professional Research Paper Writing Service | Expert Custom Research Paper Help',
                    'description' => 'Get expert research paper writing service from professional writers with advanced degrees. Our custom research paper help covers all academic levels with original research, comprehensive analysis, and perfect citations. Trusted by 10,000+ students worldwide with 24/7 support and guaranteed results.',
                    'keyPoints' => [
                        'Professional research paper writers with PhD-level expertise in your field',
                        'Custom research paper help with 100% original research and plagiarism-free content',
                        'Academic research paper service covering all disciplines with proper methodology',
                        'Research paper writing assistance with perfect APA, MLA, Chicago citations and formatting',
                    ],
                    'ctaText' => 'Get Professional Research Paper Help Now',
                    'ctaLink' => '/contact',
                    'trustSignals' => [
                        '10,000+ satisfied students',
                        '4.8/5 average rating',
                        '24/7 customer support',
                        'Money-back guarantee',
                    ],
                ],
            ],
            [
                'block_type' => 'service_overview',
                'block_key' => 'research_paper_overview',
                'order' => 2,
                'content' => [
                    'title' => 'Our Comprehensive Research Paper Writing Service',
                    'description' => 'We provide professional research paper writing across all academic disciplines with expert research methodology and academic excellence. Our custom research paper help includes original research, data analysis, and comprehensive academic writing support for students at all educational levels.',
                    'features' => [
                        [
                            'title' => 'Professional Research Paper Writers',
                            'description' => 'Expert research paper writers with advanced degrees (Master\'s & PhD) who understand academic standards, research methodologies, and discipline-specific requirements for quality research paper writing service',
                            'icon' => 'Award',
                        ],
                        [
                            'title' => 'Original Research & Analysis',
                            'description' => 'Custom research paper help with original research, primary source analysis, data collection, and comprehensive analysis tailored to your specific academic requirements and research objectives',
                            'icon' => 'Search',
                        ],
                        [
                            'title' => 'All Academic Disciplines Covered',
                            'description' => 'Academic research paper service covering sciences, humanities, business, engineering, social sciences, and specialized fields with subject-matter experts and industry professionals',
                            'icon' => 'BookOpen',
                        ],
                        [
                            'title' => 'Perfect Academic Formatting',
                            'description' => 'Professional research paper writing with proper citations, references, and formatting in APA, MLA, Chicago, Harvard, and other academic styles with attention to institutional guidelines',
                            'icon' => 'FileText',
                        ],
                    ],
                ],
            ],
            [
                'block_type' => 'service_process',
                'block_key' => 'research_paper_process',
                'order' => 3,
                'content' => [
                    'title' => 'Our Professional Research Paper Writing Process',
                    'description' => 'We follow a structured, academic approach to deliver exceptional research paper writing service with thorough research methodology, original analysis, and academic excellence that meets your institution\'s highest standards.',
                    'steps' => [
                        ['number' => 1, 'title' => 'Research Paper Topic Analysis & Planning', 'description' => 'Comprehensive analysis of your research paper requirements, academic objectives, institutional guidelines, and research scope to establish clear direction for your custom research paper help project with timeline planning.', 'icon' => 'Target'],
                        ['number' => 2, 'title' => 'Research Strategy & Methodology Development', 'description' => 'Develop comprehensive research strategy with relevant academic sources, database selection, search methodologies, and analytical frameworks for professional research paper writing service excellence.', 'icon' => 'Search'],
                        ['number' => 3, 'title' => 'Academic Source Research & Collection', 'description' => 'Conduct extensive research using scholarly databases, peer-reviewed journals, academic publications, and credible sources for your academic research paper service with source verification and quality assessment.', 'icon' => 'Database'],
                        ['number' => 4, 'title' => 'Data Collection & Statistical Analysis', 'description' => 'Gather and analyze relevant data, statistics, research findings, and empirical evidence to support your research paper writing with evidence-based arguments and comprehensive analysis.', 'icon' => 'BarChart'],
                        ['number' => 5, 'title' => 'Professional Research Paper Writing', 'description' => 'Professional research paper writers craft your paper with clear academic structure, logical flow, compelling arguments, and adherence to academic writing standards for custom research paper help excellence.', 'icon' => 'Edit'],
                        ['number' => 6, 'title' => 'Citation & Academic Formatting', 'description' => 'Apply proper academic citations, reference lists, and formatting according to your required style guide (APA, MLA, Chicago, Harvard) for research paper writing assistance with institutional compliance.', 'icon' => 'FileText'],
                        ['number' => 7, 'title' => 'Quality Review & Academic Editing', 'description' => 'Comprehensive review, editing, and proofreading to ensure your research paper meets academic standards, institutional requirements, and excellence expectations for professional research paper writing service delivery.', 'icon' => 'CheckCircle'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_benefits',
                'block_key' => 'research_paper_benefits',
                'order' => 4,
                'content' => [
                    'title' => 'Why Choose Our Professional Research Paper Writing Service',
                    'description' => 'Discover why over 10,000 students and researchers choose our expert research paper writing assistance for their academic success and career advancement',
                    'benefits' => [
                        ['title' => 'Subject-Specific Research Paper Writers', 'description' => 'Professional research paper writers with advanced degrees (Master\'s & PhD) in your specific field who understand discipline-specific requirements, research methodologies, and academic standards for exceptional results', 'icon' => 'Award'],
                        ['title' => '100% Original Research & Custom Content', 'description' => 'Custom research paper help with completely original research, unique analysis, plagiarism-free content, and comprehensive originality reports tailored to your specific academic requirements and research objectives', 'icon' => 'Shield'],
                        ['title' => 'Comprehensive Research Methodology', 'description' => 'Academic research paper service with proper research design, advanced data collection techniques, statistical analysis methods, and evidence-based conclusions that meet rigorous academic standards', 'icon' => 'Search'],
                        ['title' => 'Perfect Academic Standards Compliance', 'description' => 'Research paper writing assistance that meets all academic standards with proper structure, perfect citations, institutional formatting requirements, and adherence to academic integrity guidelines', 'icon' => 'CheckCircle'],
                        ['title' => 'Guaranteed Timely Delivery & Support', 'description' => 'Professional research paper writing service with reliable delivery schedules, 24/7 customer support, unlimited revisions, and money-back guarantee for your complete satisfaction and academic success', 'icon' => 'Clock'],
                    ],
                    'imageAlt' => 'Professional Research Paper Writing Service Benefits - Custom Research Paper Help with Expert Writers and Original Research',
                    'ctaText' => 'Order Professional Research Paper Now',
                    'ctaLink' => '/place-order',
                    'guarantees' => [
                        '100% Original Content',
                        'On-Time Delivery',
                        '24/7 Support',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                    ],
                ],
            ],
            [
                'block_type' => 'service_testimonials',
                'block_key' => 'research_paper_testimonials',
                'order' => 5,
                'content' => [
                    'title' => 'What Our Research Paper Writing Service Clients Say',
                    'description' => 'Read authentic testimonials from students and researchers who\'ve achieved academic success with our professional research paper writing assistance',
                    'testimonials' => [
                        ['text' => 'The research paper writing service I received was outstanding. The writer conducted thorough research and provided excellent analysis that impressed my professor. The custom research paper help included perfect citations and met all my university\'s requirements. I received an A+ grade!', 'author' => 'Sarah M.', 'role' => 'Graduate Student, Psychology', 'rating' => 5, 'verified' => true, 'university' => 'Stanford University'],
                        ['text' => 'I needed professional research paper writing for my master\'s thesis, and the quality exceeded my expectations. The academic research paper service provided original research with comprehensive methodology and clear presentation of findings. The writer was knowledgeable and responsive throughout the process.', 'author' => 'David L.', 'role' => 'Master\'s Student, Business Administration', 'rating' => 5, 'verified' => true, 'university' => 'Harvard Business School'],
                        ['text' => 'As an international student, I struggled with academic writing standards. The research paper writing assistance helped me understand proper formatting and citation styles while delivering a high-quality paper that earned me an A grade. The support team was available 24/7 and very helpful.', 'author' => 'Maria R.', 'role' => 'Undergraduate Student, Environmental Science', 'rating' => 5, 'verified' => true, 'university' => 'MIT'],
                    ],
                    'trustMetrics' => [
                        'totalReviews' => '1,247',
                        'averageRating' => '4.8',
                        'satisfactionRate' => '98%',
                        'repeatCustomers' => '89%',
                    ],
                ],
            ],
            [
                'block_type' => 'service_faqs',
                'block_key' => 'research_paper_faqs',
                'order' => 6,
                'content' => [
                    'title' => 'Research Paper Writing Service FAQs',
                    'description' => 'Get answers to common questions about our professional research paper writing assistance and custom research paper help services',
                    'faqs' => [
                        ['question' => 'What types of research papers does your research paper writing service handle?', 'answer' => 'Our professional research paper writing service handles all types of research papers including analytical research papers, argumentative research papers, experimental research papers, survey research papers, case study research papers, literature review research papers, comparative research papers, and empirical research papers. Our custom research paper help covers all academic levels from high school to PhD, across all disciplines including sciences, humanities, business, engineering, social sciences, medical sciences, and specialized fields. We also handle specific formats like APA research papers, MLA research papers, Chicago style research papers, and institutional-specific requirements.'],
                        ['question' => 'How do you ensure original research in your research paper writing service?', 'answer' => 'Our research paper writing service guarantees 100% original research through comprehensive database searches, primary source analysis, custom research methodology, and original data collection. Our professional research paper writers conduct fresh research for each project, avoiding pre-written content and template-based approaches. We use advanced plagiarism detection tools (Turnitin, Grammarly Premium, Copyscape) and provide detailed plagiarism reports with every custom research paper help order. Additionally, we maintain a strict no-resale policy and delete all client work after completion to ensure complete originality and confidentiality.'],
                        ['question' => 'What qualifications do your research paper writers have?', 'answer' => 'Our research paper writers hold advanced degrees (Master\'s and PhD) in their respective fields with extensive academic writing and research experience. Each professional research paper writer undergoes rigorous screening including academic credential verification, writing portfolio review, subject expertise testing, and research methodology assessment. Our academic research paper service team includes former professors, published researchers, industry professionals, and academic specialists with proven track records in their fields. We match each project with writers who have specific knowledge and experience in your research area for optimal results.'],
                        ['question' => 'How do you handle citations and formatting in your research paper writing service?', 'answer' => 'Our professional research paper writing service includes expert citation and formatting in all major academic styles including APA 7th edition, MLA 9th edition, Chicago/Turabian, Harvard, Vancouver, IEEE, and other specialized formats. Our research paper writers are trained in academic citation standards and use professional citation management tools (Zotero, Mendeley, EndNote) to ensure accuracy. Every custom research paper help order includes properly formatted in-text citations, reference lists, bibliographies, and adherence to your institution\'s specific formatting requirements including margins, spacing, font requirements, and page numbering.'],
                        ['question' => 'Can you help with research methodology for my research paper?', 'answer' => 'Yes, our academic research paper service includes comprehensive research methodology assistance and consultation. Our professional research paper writers help design appropriate research methods, select suitable data collection techniques, choose proper analytical approaches, develop research instruments, and justify methodological choices. Whether you need quantitative research methods (statistical analysis, surveys, experiments), qualitative research methods (interviews, case studies, ethnography), or mixed methods approaches, our research paper writing assistance covers all methodological aspects with expert guidance and implementation.'],
                        ['question' => 'What is your revision policy for research paper writing service?', 'answer' => 'Our research paper writing service includes unlimited free revisions within 30 days of delivery to ensure complete satisfaction. If your custom research paper help doesn\'t meet your requirements, needs adjustments, or requires modifications based on professor feedback, our professional research paper writers will revise it at no additional cost. We\'re committed to your academic success and will work with you until your research paper meets all your academic requirements, institutional standards, and personal expectations. Major revisions that change the original scope may require additional discussion, but standard revisions are always free.'],
                        ['question' => 'How do you ensure confidentiality and privacy in your research paper writing service?', 'answer' => 'Our professional research paper writing service maintains strict confidentiality and privacy protection through encrypted communication systems, secure payment processing, anonymous writer assignments, and comprehensive non-disclosure agreements. We never share client information, research topics, or completed work with third parties. All custom research paper help orders are processed with complete anonymity, and we delete all client files after project completion. Our research paper writers sign confidentiality agreements, and our platform uses SSL encryption and secure servers to protect all communications and transactions.'],
                        ['question' => 'What support do you provide after delivering my research paper?', 'answer' => 'Our research paper writing service includes comprehensive post-delivery support including free revisions, formatting adjustments, citation corrections, and academic guidance. Our 24/7 customer support team is available to address any questions or concerns about your custom research paper help order. We also provide additional services like presentation preparation, defense coaching for thesis research papers, and guidance on professor feedback implementation. Our academic research paper service commitment extends beyond delivery to ensure your complete academic success and satisfaction.'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_cta',
                'block_key' => 'research_paper_cta',
                'order' => 7,
                'content' => [
                    'title' => 'Ready to Get Professional Research Paper Help That Guarantees Results?',
                    'description' => 'Join over 10,000 successful students who\'ve achieved academic excellence with our expert research paper writing service. Get custom research paper help from professional writers with advanced degrees today.',
                    'benefits' => [
                        ['text' => 'Professional research paper writers with PhD-level expertise', 'icon' => '🏆'],
                        ['text' => '100% original research with comprehensive analysis', 'icon' => '🔍'],
                        ['text' => 'Perfect citations and academic formatting guaranteed', 'icon' => '📄'],
                        ['text' => '24/7 support with money-back guarantee', 'icon' => '🛡️'],
                    ],
                    'primaryButtonText' => 'Get Professional Research Paper Help Now',
                    'primaryButtonLink' => '/place-order',
                    'secondaryButtonText' => 'Free Research Paper Consultation',
                    'secondaryButtonLink' => '/contact',
                    'bgColor' => 'blue',
                    'urgencyText' => 'Limited Time: 15% OFF for new customers',
                    'guarantees' => [
                        '100% Original Content',
                        'On-Time Delivery',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                        '24/7 Support',
                    ],
                    'trustBadges' => [
                        'SSL Secured',
                        'Privacy Protected',
                        'Verified Writers',
                        'Academic Excellence',
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'research_paper_related_services',
                'order' => 8,
                'content' => [
                    'title' => 'Related Academic Writing Services',
                    'description' => 'Explore our comprehensive range of academic writing services designed to support your educational journey',
                    'links' => [
                        ['title' => 'Dissertation Writing Service', 'url' => '/services/dissertation-writing', 'description' => 'PhD dissertation help and doctoral thesis writing'],
                        ['title' => 'Literature Review Writing Service', 'url' => '/services/literature-reviews', 'description' => 'Professional literature review assistance and synthesis'],
                        ['title' => 'Essay Writing Service', 'url' => '/services/essay-writing', 'description' => 'Professional essay writing for all academic levels'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'research_paper_support_pages',
                'order' => 9,
                'content' => [
                    'title' => 'Learn More About Our Research Paper Writing Service',
                    'description' => 'Get detailed information about our research paper writing specialists, process, and pricing',
                    'links' => [
                        ['title' => 'Our Writers', 'url' => '/writers', 'description' => 'Meet our research paper writing specialists'],
                        ['title' => 'Pricing', 'url' => '/pricing-page', 'description' => 'Transparent research paper writing pricing'],
                        ['title' => 'Guarantees', 'url' => '/guarantees', 'description' => 'Our quality and satisfaction guarantees'],
                        ['title' => 'Reviews', 'url' => '/reviews', 'description' => 'Read customer reviews and testimonials'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'research_paper_resource_links',
                'order' => 10,
                'content' => [
                    'title' => 'Professional Research Paper Writing Service Resources',
                    'links' => [
                        ['title' => 'Research Paper Writing Guide', 'url' => '/blog/research-paper-writing-guide', 'description' => 'Complete guide to writing research papers'],
                        ['title' => 'Research Methodology Basics', 'url' => '/blog/research-methodology-basics', 'description' => 'Understanding research methods and approaches'],
                        ['title' => 'Academic Citation Guide', 'url' => '/blog/academic-citation-guide', 'description' => 'Master APA, MLA, and Chicago citation styles'],
                        ['title' => 'Research Paper Topics', 'url' => '/blog/research-paper-topics', 'description' => 'Inspiring research paper topic ideas'],
                    ],
                ],
            ],
        ];

        // Upsert content blocks
        foreach ($blocks as $i => $block) {
            PageContent::updateOrCreate(
                [
                    'page_id' => $page->id,
                    'block_key' => $block['block_key'],
                ],
                [
                    'block_type' => $block['block_type'],
                    'content' => $block['content'],
                    'order' => $block['order'] ?? ($i + 1),
                    'is_active' => true,
                ]
            );
        }

        $this->command->info('Research Papers service content seeded successfully!');
    }
}
