<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedServiceThesisProposals extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create/update the page for Thesis Proposals service
        $page = Page::updateOrCreate(
            ['slug' => 'thesis-proposals'],
            [
                'title' => 'Thesis Statement Writing Service',
                'page_type' => 'service',
                'status' => 'published',
                'template' => 'Services/ThesisStatements',
                'seo_priority' => 80,
                'published_at' => now(),
            ]
        );

        // Structured data
        $structuredData = [
            'service' => [
                '@context' => 'https://schema.org',
                '@type' => 'Service',
                'name' => 'Professional Thesis Statement Writing Service',
                'description' => 'Expert thesis statement writing service with PhD-qualified writers providing clear, arguable, and focused thesis statements for essays, research papers, and dissertations.',
                'provider' => [
                    '@type' => 'Organization',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                    'logo' => 'https://academicscribe.com/images/logo.png',
                    'contactPoint' => [
                        '@type' => 'ContactPoint',
                        'telephone' => '+1-555-123-4567',
                        'contactType' => 'customer service',
                        'availableLanguage' => ['English'],
                        'areaServed' => 'Worldwide',
                    ],
                    'address' => [
                        '@type' => 'PostalAddress',
                        'addressCountry' => 'US',
                        'addressRegion' => 'Global',
                    ],
                    'sameAs' => [
                        'https://facebook.com/academicscribe',
                        'https://twitter.com/academicscribe',
                        'https://linkedin.com/company/academicscribe',
                    ],
                ],
                'serviceType' => 'Academic Writing Service',
                'areaServed' => 'Worldwide',
            ],
            'breadcrumb' => [
                '@context' => 'https://schema.org',
                '@type' => 'BreadcrumbList',
                'itemListElement' => [
                    [
                        '@type' => 'ListItem',
                        'position' => 1,
                        'name' => 'Home',
                        'item' => 'https://academicscribe.com',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 2,
                        'name' => 'Services',
                        'item' => 'https://academicscribe.com/services',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 3,
                        'name' => 'Thesis Statement Writing Service',
                        'item' => 'https://academicscribe.com/services/thesis-proposals',
                    ],
                ],
            ],
            'organization' => [
                '@context' => 'https://schema.org',
                '@type' => 'Organization',
                'name' => 'Academic Scribe',
                'description' => 'Professional academic writing services with expert thesis statement writers providing comprehensive thesis development help for students worldwide.',
                'url' => 'https://academicscribe.com',
                'logo' => 'https://academicscribe.com/images/logo.png',
                'image' => 'https://academicscribe.com/images/thesis-statement-writing-service.jpg',
                'contactPoint' => [
                    '@type' => 'ContactPoint',
                    'telephone' => '+1-555-123-4567',
                    'contactType' => 'customer service',
                    'availableLanguage' => ['English'],
                    'areaServed' => 'Worldwide',
                ],
                'address' => [
                    '@type' => 'PostalAddress',
                    'addressCountry' => 'US',
                    'addressRegion' => 'Global',
                ],
                'sameAs' => [
                    'https://facebook.com/academicscribe',
                    'https://twitter.com/academicscribe',
                    'https://linkedin.com/company/academicscribe',
                ],
            ],
            'website' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebSite',
                'name' => 'Academic Scribe - Thesis Statement Writing Service',
                'description' => 'Professional thesis statement writers providing expert thesis help and comprehensive thesis development service for students at all academic levels.',
                'url' => 'https://academicscribe.com/services/thesis-proposals',
                'potentialAction' => [
                    '@type' => 'SearchAction',
                    'target' => 'https://academicscribe.com/search?q={search_term_string}',
                    'query-input' => 'required name=search_term_string',
                ],
            ],
            'webpage' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebPage',
                'name' => 'Professional Thesis Statement Writing Service | Expert Thesis Help',
                'description' => 'Expert thesis statement writing service with PhD-qualified writers. Get professional thesis statement help for essays, research papers, and dissertations. Clear, arguable, and focused statements.',
                'url' => 'https://academicscribe.com/services/thesis-proposals',
                'isPartOf' => [
                    '@type' => 'WebSite',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                ],
                'about' => [
                    '@type' => 'Service',
                    'name' => 'Thesis Statement Writing Service',
                ],
                'mainEntity' => [
                    '@type' => 'Service',
                    'name' => 'Professional Thesis Statement Writing Service',
                ],
            ],
        ];

        // SEO data
        PageSeo::updateOrCreate(
            ['page_id' => $page->id],
            [
                'meta_title' => 'Professional Thesis Statement Writing Service | Expert Thesis Help | Academic Scribe',
                'meta_description' => 'Expert thesis statement writing service with PhD-qualified writers. Get professional thesis statement help for essays, research papers, and dissertations. Clear, arguable, and focused statements.',
                'meta_keywords' => 'thesis statement writing service, thesis statement help, professional thesis writing, argumentative thesis statements, analytical thesis development, research thesis help, thesis statement writers, custom thesis statements',
                'canonical_url' => 'https://academicscribe.com/services/thesis-proposals',
                'og_url' => 'https://academicscribe.com/services/thesis-proposals',
                'robots' => 'index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1',
                'language' => 'en-US',
                'structured_data' => $structuredData,
                'twitter_card' => 'summary_large_image',
                'twitter_title' => 'Professional Thesis Statement Writing Service | Expert Thesis Help',
                'twitter_description' => 'Expert thesis statement writing service with PhD-qualified writers. Get professional thesis statement help for all types of academic papers.',
                'twitter_image' => 'https://academicscribe.com/images/thesis-statement-writing-service-twitter.jpg',
                'og_title' => 'Professional Thesis Statement Writing Service | Expert Thesis Help',
                'og_description' => 'Expert thesis statement writing service with PhD-qualified writers. Get professional thesis statement help for essays, research papers, and dissertations. Clear, arguable, and focused statements.',
                'og_image' => 'https://academicscribe.com/images/thesis-statement-writing-service-og.jpg',
                'og_type' => 'website',
            ]
        );

        // Content blocks
        $blocks = [
            [
                'block_type' => 'service_hero',
                'block_key' => 'thesis_hero',
                'order' => 1,
                'content' => [
                    'title' => 'Professional Thesis Statement Writing Service | Expert Thesis Help',
                    'description' => 'Get expert thesis statement writing service from PhD-qualified writers. Our professional thesis statement assistance covers all types of academic papers - from argumentative essays to research dissertations. Trusted by thousands of students worldwide.',
                    'keyPoints' => [
                        'PhD-qualified thesis statement writers with expertise in your field',
                        'Complete thesis statement help - from development to refinement',
                        'Custom thesis statements for essays, research papers, and dissertations',
                        'Professional thesis writing service with 24/7 support',
                    ],
                    'ctaText' => 'Get Professional Thesis Help',
                    'ctaLink' => '/contact',
                    'trustSignals' => [
                        '10,000+ satisfied students',
                        '4.9/5 average rating',
                        '24/7 customer support',
                        'Money-back guarantee',
                    ],
                ],
            ],
            [
                'block_type' => 'service_overview',
                'block_key' => 'thesis_overview',
                'order' => 2,
                'content' => [
                    'title' => 'Our Comprehensive Thesis Statement Writing Service',
                    'description' => 'We provide professional thesis statement writing service tailored to your academic needs and discipline. Our expert thesis statement help covers all types of academic writing with clear, arguable, and focused statements.',
                    'features' => [
                        [
                            'title' => 'Argumentative Thesis Statements',
                            'description' => 'Expert thesis statement writers craft clear, debatable positions that establish strong foundations for argumentative essays and research papers',
                            'icon' => 'MessageSquare',
                        ],
                        [
                            'title' => 'Analytical Thesis Development',
                            'description' => 'Professional thesis statement help with analytical approaches that break down complex topics into manageable components for academic analysis',
                            'icon' => 'Search',
                        ],
                        [
                            'title' => 'Research Thesis Statements',
                            'description' => 'Comprehensive thesis statement writing service for research papers and dissertations with clear research questions and expected contributions',
                            'icon' => 'BookOpen',
                        ],
                        [
                            'title' => 'Expository Thesis Writing',
                            'description' => 'Expert development of expository thesis statements that clearly outline explanatory approaches for informative academic papers',
                            'icon' => 'FileText',
                        ],
                    ],
                ],
            ],
            [
                'block_type' => 'service_process',
                'block_key' => 'thesis_process',
                'order' => 3,
                'content' => [
                    'title' => 'Our Professional Thesis Statement Writing Process',
                    'description' => 'We follow a structured approach to provide comprehensive thesis statement help, developing clear and focused statements that guide your entire academic paper.',
                    'steps' => [
                        ['number' => 1, 'title' => 'Topic Analysis & Research', 'description' => 'Analyze your assignment topic and conduct preliminary research to identify key themes, controversies, and potential positions for your thesis statement.', 'icon' => 'Search'],
                        ['number' => 2, 'title' => 'Position Development', 'description' => 'Develop a clear, arguable position or analytical approach based on your topic requirements and academic discipline with expert thesis statement help.', 'icon' => 'Target'],
                        ['number' => 3, 'title' => 'Statement Crafting', 'description' => 'Craft a precise, concise thesis statement that articulates your position clearly and provides direction for your entire academic paper.', 'icon' => 'Edit'],
                        ['number' => 4, 'title' => 'Scope & Focus Refinement', 'description' => 'Refine the thesis statement scope to ensure it\'s neither too broad nor too narrow, perfectly suited for your assignment length and requirements.', 'icon' => 'Maximize'],
                        ['number' => 5, 'title' => 'Argument Structure Planning', 'description' => 'Outline the key supporting arguments and evidence that will develop from your thesis statement throughout your academic paper.', 'icon' => 'List'],
                        ['number' => 6, 'title' => 'Statement Testing & Validation', 'description' => 'Test the thesis statement for clarity, arguability, and effectiveness in guiding a coherent and persuasive academic argument.', 'icon' => 'CheckCircle'],
                        ['number' => 7, 'title' => 'Final Polish & Delivery', 'description' => 'Polish the thesis statement for academic tone, precision, and impact, ensuring it meets your discipline\'s conventions and requirements.', 'icon' => 'Award'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_benefits',
                'block_key' => 'thesis_benefits',
                'order' => 4,
                'content' => [
                    'title' => 'Benefits of Our Professional Thesis Statement Writing Service',
                    'description' => 'Discover why students choose our expert thesis statement help for their academic success',
                    'benefits' => [
                        ['title' => 'Clear Direction & Focus', 'description' => 'Professional thesis statement writing service provides clear direction for your entire paper, ensuring focused arguments and coherent structure throughout', 'icon' => 'Compass'],
                        ['title' => 'Discipline-Specific Expertise', 'description' => 'Expert thesis statement help from writers with advanced degrees in your field who understand discipline-specific conventions and requirements', 'icon' => 'Award'],
                        ['title' => 'Arguable & Defensible Positions', 'description' => 'Custom thesis statements that present defensible positions rather than obvious facts, creating engaging academic arguments that invite scholarly discussion', 'icon' => 'MessageSquare'],
                        ['title' => 'Proper Academic Scope', 'description' => 'Professional thesis writing service ensures your statement has appropriate scope - neither too broad nor too narrow for your assignment requirements', 'icon' => 'Maximize'],
                        ['title' => 'Supporting Framework Guidance', 'description' => 'Comprehensive thesis statement help includes guidance on key arguments and evidence structure to support your thesis throughout your paper', 'icon' => 'Layers'],
                    ],
                    'imageAlt' => 'Professional Thesis Statement Writing Service Benefits - Expert Thesis Help with Clear, Arguable, and Focused Statements',
                    'ctaText' => 'Start Your Thesis Project',
                    'ctaLink' => '/place-order',
                    'guarantees' => [
                        '100% Original Content',
                        'On-Time Delivery',
                        '24/7 Support',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                    ],
                ],
            ],
            [
                'block_type' => 'service_testimonials',
                'block_key' => 'thesis_testimonials',
                'order' => 5,
                'content' => [
                    'title' => 'What Our Thesis Statement Writing Service Clients Say',
                    'description' => 'Read testimonials from students who\'ve used our professional thesis statement help',
                    'testimonials' => [
                        ['text' => 'The thesis statement writing service I received was exceptional. My writer helped me develop a clear, arguable thesis that perfectly captured my position while being specific enough to guide my entire research paper. The supporting argument framework was invaluable.', 'author' => 'Marcus T.', 'role' => 'Political Science Major', 'rating' => 5, 'verified' => true, 'university' => 'Georgetown University'],
                        ['text' => 'Working with this professional thesis statement writing service transformed my approach to academic writing. They provided expert thesis statement help that refined my vague ideas into a focused, defensible position that impressed my professor.', 'author' => 'Sophia R.', 'role' => 'Engineering Student', 'rating' => 5, 'verified' => true, 'university' => 'MIT'],
                        ['text' => 'As an international student, I struggled with crafting effective thesis statements. The thesis statement help I received not only gave me a strong foundation for my paper but also taught me the principles of effective academic argumentation.', 'author' => 'Jordan K.', 'role' => 'Literature Student', 'rating' => 5, 'verified' => true, 'university' => 'Yale University'],
                    ],
                    'trustMetrics' => [
                        'totalReviews' => '1,156',
                        'averageRating' => '4.9',
                        'satisfactionRate' => '98%',
                        'repeatCustomers' => '87%',
                    ],
                ],
            ],
            [
                'block_type' => 'service_faqs',
                'block_key' => 'thesis_faqs',
                'order' => 6,
                'content' => [
                    'title' => 'Thesis Statement Writing Service FAQs',
                    'description' => 'Common questions about our professional thesis statement help and academic writing services',
                    'faqs' => [
                        ['question' => 'How does your professional thesis statement writing service work?', 'answer' => 'Our thesis statement writing service begins with a thorough analysis of your assignment topic and requirements. We assign a qualified writer in your field who conducts preliminary research, develops a clear position, and crafts a precise thesis statement. Our professional thesis statement help includes scope refinement, argument structure planning, and final polishing to ensure your statement effectively guides your entire paper.'],
                        ['question' => 'What makes a strong thesis statement according to your service?', 'answer' => 'Our thesis statement writing service focuses on creating statements that are clear and concise, arguable rather than factual, appropriately scoped for your assignment, discipline-specific in approach, and supported by available evidence. We ensure your thesis statement provides clear direction for your paper while presenting a position that invites scholarly discussion and can be effectively defended throughout your academic work.'],
                        ['question' => 'Can you provide thesis statement help for different types of papers?', 'answer' => 'Yes, our professional thesis statement writing service covers all types of academic papers. We provide expert thesis statement help for argumentative essays, analytical papers, research studies, expository writing, comparative analyses, and dissertation proposals. Our writers adapt their approach based on your paper type, ensuring your thesis statement aligns with the specific requirements and conventions of your assignment.'],
                        ['question' => 'How do you ensure my thesis statement is original and plagiarism-free?', 'answer' => 'Our thesis statement writing service guarantees 100% original work. Each thesis statement is crafted specifically for your topic and requirements by our expert writers. We never reuse or resell thesis statements, and all work undergoes plagiarism checking before delivery. Your professional thesis statement help includes a unique position developed through original analysis of your specific topic and academic context.'],
                        ['question' => 'What if I need revisions to my thesis statement?', 'answer' => 'Our thesis statement writing service includes free revisions to ensure your complete satisfaction. If your thesis statement needs adjustments based on your feedback or professor\'s comments, we provide prompt revisions at no additional cost. Our professional thesis statement help continues until you have a statement that perfectly captures your intended argument and meets all your requirements.'],
                        ['question' => 'How quickly can you provide thesis statement help?', 'answer' => 'Our professional thesis statement writing service offers flexible deadlines to meet your needs. We can provide expert thesis statement help within 24 hours for urgent requests, though we recommend allowing more time for complex topics or research-intensive statements. Rush orders are available with our experienced writers who specialize in delivering high-quality thesis statements under tight deadlines.'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_cta',
                'block_key' => 'thesis_cta',
                'order' => 7,
                'content' => [
                    'title' => 'Ready to Get Professional Thesis Statement Help?',
                    'description' => 'Our expert thesis statement writing service is ready to help you create clear, focused, and arguable thesis statements. Get professional thesis statement help from qualified writers today.',
                    'benefits' => [
                        ['text' => 'PhD-qualified thesis statement writers in your discipline', 'icon' => '🏆'],
                        ['text' => 'Clear, arguable, and focused thesis statements', 'icon' => '🎯'],
                        ['text' => 'Comprehensive thesis statement writing assistance', 'icon' => '📄'],
                        ['text' => '24/7 support with money-back guarantee', 'icon' => '🛡️'],
                    ],
                    'primaryButtonText' => 'Get Professional Thesis Help',
                    'primaryButtonLink' => '/place-order',
                    'secondaryButtonText' => 'Free Thesis Consultation',
                    'secondaryButtonLink' => '/contact',
                    'bgColor' => 'blue',
                    'urgencyText' => 'Limited Time: 15% OFF for new students',
                    'guarantees' => [
                        '100% Original Content',
                        'On-Time Delivery',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                        '24/7 Support',
                    ],
                    'trustBadges' => [
                        'SSL Secured',
                        'Privacy Protected',
                        'Expert Writers',
                        'Academic Excellence',
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'thesis_related_services',
                'order' => 8,
                'content' => [
                    'title' => 'Related Academic Writing Services',
                    'description' => 'Explore our comprehensive range of academic writing services',
                    'links' => [
                        ['title' => 'Essay Writing Service', 'url' => '/services/essay-writing', 'description' => 'Professional essay writing for all academic levels'],
                        ['title' => 'Research Paper Writing Service', 'url' => '/services/research-papers', 'description' => 'Expert research paper help and academic research writing'],
                        ['title' => 'Dissertation Writing Service', 'url' => '/services/dissertation-writing', 'description' => 'PhD dissertation help and doctoral thesis writing'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'thesis_support_pages',
                'order' => 9,
                'content' => [
                    'title' => 'Learn More About Our Thesis Statement Writing Service',
                    'description' => 'Get detailed information about our thesis statement specialists',
                    'links' => [
                        ['title' => 'Our Writers', 'url' => '/writers', 'description' => 'Meet our thesis statement writing specialists'],
                        ['title' => 'Pricing', 'url' => '/pricing-page', 'description' => 'Transparent thesis statement writing pricing'],
                        ['title' => 'Guarantees', 'url' => '/guarantees', 'description' => 'Our quality and satisfaction guarantees'],
                        ['title' => 'Reviews', 'url' => '/reviews', 'description' => 'Read customer reviews and testimonials'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'thesis_resource_links',
                'order' => 10,
                'content' => [
                    'title' => 'Professional Thesis Statement Writing Service Resources',
                    'links' => [
                        ['title' => 'Thesis Statement Writing Guide', 'url' => '/blog/thesis-statement-writing-guide', 'description' => 'Complete guide to crafting effective thesis statements'],
                        ['title' => 'Argumentative Thesis Tips', 'url' => '/blog/argumentative-thesis-tips', 'description' => 'Creating strong argumentative positions'],
                        ['title' => 'Research Thesis Development', 'url' => '/blog/research-thesis-development', 'description' => 'Developing research-focused thesis statements'],
                    ],
                ],
            ],
        ];

        // Upsert content blocks
        foreach ($blocks as $i => $block) {
            PageContent::updateOrCreate(
                [
                    'page_id' => $page->id,
                    'block_key' => $block['block_key'],
                ],
                [
                    'block_type' => $block['block_type'],
                    'content' => $block['content'],
                    'order' => $block['order'] ?? ($i + 1),
                    'is_active' => true,
                ]
            );
        }

        $this->command->info('Thesis Proposals service content seeded successfully!');
    }
}
