<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedWritersPageComplete extends Seeder
{
    public function run()
    {
        // Delete existing writers page if it exists
        $existingPage = Page::where('slug', 'writers')->first();
        if ($existingPage) {
            $existingPage->contentBlocks()->delete();
            $existingPage->seo()->delete();
            $existingPage->delete();
        }

        // Create the Writers page
        $page = Page::create([
            'title' => 'Professional Essay Writers for Hire - Academic Scribe',
            'slug' => 'writers',
            'page_type' => 'landing',
            'status' => 'published',
            'template' => 'default',
            'seo_priority' => 90,
            'published_at' => now(),
        ]);

        // Create SEO data (EXACT from original)
        PageSeo::create([
            'page_id' => $page->id,
            'meta_title' => 'Professional Essay Writers for Hire | 847+ Expert Academic Writers | Academic Scribe',
            'meta_description' => 'Hire professional essay writers with PhD and Masters degrees. 847+ qualified academic writers available for custom essays, research papers, dissertations, and assignments. Expert writers for students worldwide.',
            'meta_keywords' => 'essay writers for hire, professional academic writers, expert writers, PhD writers, research paper writers, dissertation writers, assignment help writers, qualified essay writers, academic writing experts, hire essay writer, professional writing service, custom essay writers',
            'canonical_url' => 'https://academicscribe.com/writers',
            'robots' => 'index, follow',
            'og_title' => 'Professional Essay Writers for Hire | 847+ Expert Academic Writers',
            'og_description' => 'Hire qualified essay writers with advanced degrees. Expert academic writers available for custom papers, research, and assignments. Professional writing help for students.',
            'og_image' => '/images/writers-og.jpg',
            'og_type' => 'website',
            'twitter_card' => 'summary_large_image',
            'twitter_title' => 'Professional Essay Writers for Hire | Expert Academic Writers',
            'twitter_description' => 'Hire qualified essay writers with PhD and Masters degrees. 847+ expert academic writers available for custom papers and assignments.',
            'twitter_image' => '/images/writers-twitter.jpg',
        ]);

        // Block 1: Hero with Stats
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'writers_hero',
            'block_key' => 'writers_hero',
            'order' => 1,
            'is_active' => true,
            'content' => [
                'title' => 'Professional Essay Writers for Hire',
                'description' => 'Hire expert academic writers with <strong>PhD and Masters degrees</strong>. Our <em>847+ qualified writers</em> deliver custom essays, research papers, dissertations, and assignments with guaranteed quality.',
                'stats' => [
                    ['value' => '847', 'label' => 'Expert Writers'],
                    ['value' => '312', 'label' => 'PhD Writers'],
                    ['value' => '8.5+', 'label' => 'Years Experience'],
                    ['value' => '98.7%', 'label' => 'Satisfaction Rate'],
                    ['value' => '45,678', 'label' => 'Papers Completed'],
                    ['value' => '99.2%', 'label' => 'On-Time Delivery'],
                    ['value' => '100+', 'label' => 'Academic Disciplines'],
                ]
            ]
        ]);

        // Block 2: Selection Process (6 steps with tabs)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'selection_process',
            'block_key' => 'selection_process',
            'order' => 2,
            'is_active' => true,
            'content' => [
                'title' => 'Our Rigorous Writer Selection Process',
                'description' => 'Only <strong>3% of applicants</strong> successfully complete our comprehensive <em>6-step selection process</em> to become professional essay writers',
                'processes' => [
                    [
                        'id' => 'presentation',
                        'title' => 'Video Presentation',
                        'subtitle' => 'We let writers present their portfolios and skills',
                        'description' => 'Every potential writer must submit a comprehensive video presentation showcasing their academic background, writing expertise, and communication skills. We evaluate their ability to articulate complex ideas clearly and professionally.',
                        'icon' => '🎥',
                        'details' => [
                            'Academic credentials verification',
                            'Portfolio review and assessment',
                            'Communication skills evaluation',
                            'Professional presentation skills',
                            'Subject matter expertise demonstration',
                        ],
                    ],
                    [
                        'id' => 'creative',
                        'title' => 'Creative Task',
                        'subtitle' => 'We see how candidates deal with the writing AI cannot do',
                        'description' => 'Our creative writing challenges test candidates\' ability to produce original, thoughtful content that requires human insight, creativity, and critical thinking - areas where AI falls short.',
                        'icon' => '🎨',
                        'details' => [
                            'Original thinking and creativity',
                            'Critical analysis capabilities',
                            'Unique perspective development',
                            'Complex argumentation skills',
                            'Human insight and empathy',
                        ],
                    ],
                    [
                        'id' => 'testing',
                        'title' => 'Multilayered Test',
                        'subtitle' => 'We check writers\' logic, attention, and argumentation',
                        'description' => 'Comprehensive testing evaluates logical reasoning, attention to detail, and argumentation skills through multiple assessment layers designed by academic experts.',
                        'icon' => '🧠',
                        'details' => [
                            'Logical reasoning assessment',
                            'Attention to detail evaluation',
                            'Argumentation structure analysis',
                            'Research methodology testing',
                            'Academic writing standards check',
                        ],
                    ],
                    [
                        'id' => 'final',
                        'title' => 'Final Essay',
                        'subtitle' => 'We try them with an urgent task and video presentation',
                        'description' => 'The final challenge combines time pressure with quality expectations. Writers must complete a complex essay under tight deadlines while maintaining our high standards.',
                        'icon' => '📝',
                        'details' => [
                            'Time management under pressure',
                            'Quality maintenance in urgency',
                            'Research efficiency',
                            'Writing speed and accuracy',
                            'Stress performance evaluation',
                        ],
                    ],
                    [
                        'id' => 'onboarding',
                        'title' => 'Onboarding',
                        'subtitle' => 'We help writers understand our mission, values, and goals',
                        'description' => 'Successful candidates undergo comprehensive onboarding to align with our mission of providing exceptional academic support while maintaining ethical standards.',
                        'icon' => '🎯',
                        'details' => [
                            'Mission and values alignment',
                            'Quality standards training',
                            'Client communication protocols',
                            'Ethical guidelines education',
                            'Platform and tools training',
                        ],
                    ],
                    [
                        'id' => 'quality',
                        'title' => 'Quality Control',
                        'subtitle' => 'We supervise writers as they complete their first orders',
                        'description' => 'New writers receive intensive supervision and mentoring during their first orders to ensure they meet our exacting standards before working independently.',
                        'icon' => '🛡️',
                        'details' => [
                            'First order supervision',
                            'Quality assurance monitoring',
                            'Feedback and improvement guidance',
                            'Performance evaluation',
                            'Continuous improvement support',
                        ],
                    ],
                ],
            ]
        ]);

        // Block 3: Writer Superpowers
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'writer_superpowers',
            'block_key' => 'writer_superpowers',
            'order' => 3,
            'is_active' => true,
            'content' => [
                'title' => 'What Makes Our Essay Writers Stand Out',
                'description' => 'Our <strong>professional academic writers</strong> possess unique qualities that ensure exceptional results for every paper',
                'superpowers' => [
                    [
                        'title' => 'Follow Instructions Precisely',
                        'description' => 'Our essay writers for hire excel at understanding and following detailed academic requirements, ensuring every paper meets specific guidelines and expectations.',
                        'icon' => '📋',
                        'benefits' => [
                            'Detailed requirement analysis',
                            'Precise formatting adherence',
                            'Custom specification following',
                            'Academic standard compliance',
                        ],
                    ],
                    [
                        'title' => 'Communicate Clearly',
                        'description' => 'Professional academic writers maintain transparent communication throughout the writing process, providing updates and clarifications when needed.',
                        'icon' => '💬',
                        'benefits' => [
                            'Regular progress updates',
                            'Clear question clarification',
                            'Responsive communication',
                            'Professional interaction',
                        ],
                    ],
                    [
                        'title' => 'Deliver Quality Work',
                        'description' => 'Expert writers for hire consistently produce high-quality academic papers that exceed expectations and meet rigorous academic standards.',
                        'icon' => '⭐',
                        'benefits' => [
                            'Original research and analysis',
                            'Proper citation and referencing',
                            'Error-free writing',
                            'Academic excellence',
                        ],
                    ],
                ]
            ]
        ]);

        // Block 4: Quality Control Features
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'quality_control',
            'block_key' => 'quality_control',
            'order' => 4,
            'is_active' => true,
            'content' => [
                'title' => 'What About Quality Control?',
                'description' => 'We maintain <strong>rigorous quality standards</strong> through continuous monitoring, support, and improvement programs',
                'features' => [
                    [
                        'title' => 'Unique Rating System',
                        'subtitle' => 'We track every writer\'s step and reward their efforts',
                        'description' => 'Our comprehensive rating system monitors writer performance across multiple metrics, ensuring consistent quality and rewarding excellence.',
                        'icon' => '📊',
                        'metrics' => [
                            'Quality score tracking',
                            'Client satisfaction ratings',
                            'Deadline adherence',
                            'Communication effectiveness',
                            'Revision requirements',
                        ],
                    ],
                    [
                        'title' => 'Performance Support',
                        'subtitle' => 'Our caring supervisors are on standby to help when needed',
                        'description' => 'Dedicated supervisors provide ongoing support to writers, helping them overcome challenges and maintain high performance standards.',
                        'icon' => '🤝',
                        'support' => [
                            '24/7 supervisor availability',
                            'Technical assistance',
                            'Quality improvement guidance',
                            'Problem-solving support',
                            'Professional development',
                        ],
                    ],
                    [
                        'title' => 'Quality Control Team',
                        'subtitle' => 'All our writers get detailed feedback and regular coaching',
                        'description' => 'Our quality control team provides continuous feedback and coaching to help writers improve their skills and maintain excellence.',
                        'icon' => '👥',
                        'services' => [
                            'Detailed performance feedback',
                            'Regular coaching sessions',
                            'Skill development programs',
                            'Best practice sharing',
                            'Continuous improvement',
                        ],
                    ],
                ],
                'stats' => [
                    ['value' => '98.7%', 'label' => 'Satisfaction Rate'],
                    ['value' => '99.2%', 'label' => 'On-Time Delivery'],
                ]
            ]
        ]);

        // Block 5: Client Benefits
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'client_benefits',
            'block_key' => 'client_benefits',
            'order' => 5,
            'is_active' => true,
            'content' => [
                'title' => 'How Clients Benefit from Our Professional Writers',
                'description' => 'Experience the advantages of working with <strong>expert academic writers</strong> who prioritize your success',
                'benefits' => [
                    [
                        'title' => 'Expert Matching',
                        'subtitle' => 'We find the one best fit to write your paper',
                        'description' => 'Our sophisticated matching system pairs you with the most qualified writer for your specific academic needs and subject area.',
                        'icon' => '🎯',
                        'features' => [
                            'Subject expertise matching',
                            'Academic level alignment',
                            'Writing style compatibility',
                            'Experience level consideration',
                            'Availability optimization',
                        ],
                    ],
                    [
                        'title' => 'Quick Assigning',
                        'subtitle' => 'We give you the right expert ASAP',
                        'description' => 'Efficient assignment process ensures you get matched with qualified essay writers for hire quickly, even for urgent deadlines.',
                        'icon' => '⚡',
                        'features' => [
                            'Rapid writer assignment',
                            'Urgent deadline handling',
                            'Immediate availability check',
                            'Fast response guarantee',
                            'Priority matching system',
                        ],
                    ],
                    [
                        'title' => 'Your Interests at Heart',
                        'subtitle' => 'Our experts give solutions you can count on',
                        'description' => 'Professional academic writers prioritize your success, providing reliable solutions that meet your academic goals and requirements.',
                        'icon' => '❤️',
                        'features' => [
                            'Student success focus',
                            'Reliable solution delivery',
                            'Academic goal alignment',
                            'Personalized approach',
                            'Success-oriented mindset',
                        ],
                    ],
                    [
                        'title' => 'Timely Delivery',
                        'subtitle' => 'Get your quality, custom paper done on time',
                        'description' => 'Expert writers for hire consistently meet deadlines while maintaining high quality standards, ensuring you never miss submission dates.',
                        'icon' => '⏰',
                        'features' => [
                            'Guaranteed on-time delivery',
                            'Quality maintenance',
                            'Deadline tracking',
                            'Progress monitoring',
                            'Time management excellence',
                        ],
                    ],
                    [
                        'title' => 'Free Revisions',
                        'subtitle' => 'Stay in touch and ask for free edits if needed',
                        'description' => 'Our commitment to your satisfaction includes unlimited free revisions to ensure your paper meets all requirements perfectly.',
                        'icon' => '🔄',
                        'features' => [
                            'Unlimited free revisions',
                            'Quality guarantee',
                            'Satisfaction assurance',
                            'Continuous improvement',
                            'Perfect paper promise',
                        ],
                    ],
                ],
            ]
        ]);

        // Block 6: Featured Writers (3 writer profiles)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'featured_writers',
            'block_key' => 'featured_writers',
            'order' => 6,
            'is_active' => true,
            'content' => [
                'title' => 'Meet Some of Our Top-Rated Writers',
                'description' => 'Browse profiles of our <strong>experienced academic writers</strong> who have helped thousands of students succeed',
                'writers' => [
                    [
                        'id' => 1,
                        'name' => 'Dr. Sarah Johnson',
                        'title' => 'PhD in English Literature',
                        'specialization' => 'Essay Writing, Literature Analysis',
                        'experience' => '12 years',
                        'completedOrders' => 2847,
                        'rating' => 4.9,
                        'expertise' => ['Academic Essays', 'Literary Analysis', 'Creative Writing', 'Research Papers'],
                        'education' => 'Harvard University - PhD English Literature',
                        'description' => 'Expert essay writer specializing in literature analysis and academic writing. Proven track record of helping students achieve academic excellence.',
                        'languages' => ['English (Native)', 'Spanish (Fluent)'],
                        'availability' => 'Available',
                    ],
                    [
                        'id' => 2,
                        'name' => 'Prof. Michael Chen',
                        'title' => 'PhD in Psychology',
                        'specialization' => 'Research Papers, Case Studies',
                        'experience' => '15 years',
                        'completedOrders' => 3156,
                        'rating' => 4.9,
                        'expertise' => ['Psychology Papers', 'Research Methodology', 'Statistical Analysis', 'Case Studies'],
                        'education' => 'Stanford University - PhD Psychology',
                        'description' => 'Professional academic writer with extensive experience in psychology research and statistical analysis. Specializes in complex research papers.',
                        'languages' => ['English (Native)', 'Mandarin (Native)'],
                        'availability' => 'Available',
                    ],
                    [
                        'id' => 3,
                        'name' => 'Dr. Emma Rodriguez',
                        'title' => 'PhD in Business Administration',
                        'specialization' => 'Business Papers, MBA Assignments',
                        'experience' => '10 years',
                        'completedOrders' => 2234,
                        'rating' => 4.8,
                        'expertise' => ['Business Strategy', 'Marketing Analysis', 'Financial Reports', 'MBA Essays'],
                        'education' => 'Wharton School - PhD Business Administration',
                        'description' => 'Expert business writer helping MBA students and professionals with complex business analyses and strategic papers.',
                        'languages' => ['English (Native)', 'Spanish (Native)'],
                        'availability' => 'Available',
                    ],
                ],
            ]
        ]);

        // Block 7: Writer Expertise (6 key points)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'writer_expertise',
            'block_key' => 'writer_expertise',
            'order' => 7,
            'is_active' => true,
            'content' => [
                'title' => 'Why Choose Our Professional Academic Writers',
                'description' => 'Our <strong>expert writers</strong> combine academic excellence with practical experience',
                'expertise' => [
                    [
                        'icon' => '🎓',
                        'title' => 'Advanced Degrees',
                        'description' => 'All our writers hold Masters or PhD degrees from accredited universities, ensuring expert-level knowledge in their fields.',
                    ],
                    [
                        'icon' => '📚',
                        'title' => 'Subject Expertise',
                        'description' => 'Specialized knowledge across 100+ academic disciplines, from literature and history to engineering and medicine.',
                    ],
                    [
                        'icon' => '🌍',
                        'title' => 'Native English Speakers',
                        'description' => 'Professional writers who are native English speakers, ensuring perfect grammar, style, and academic tone.',
                    ],
                    [
                        'icon' => '⏰',
                        'title' => 'Deadline Reliability',
                        'description' => '99.2% on-time delivery rate with writers who understand the importance of meeting academic deadlines.',
                    ],
                    [
                        'icon' => '🔍',
                        'title' => 'Original Research',
                        'description' => 'Expert researchers who conduct thorough, original research using credible academic sources and proper citations.',
                    ],
                    [
                        'icon' => '💬',
                        'title' => 'Direct Communication',
                        'description' => 'Direct communication with your assigned writer throughout the process for updates, clarifications, and revisions.',
                    ],
                ]
            ]
        ]);

        // Block 8: FAQs
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'writers_faqs',
            'block_key' => 'writers_faqs',
            'order' => 8,
            'is_active' => true,
            'content' => [
                'title' => 'Frequently Asked Questions About Our Writers',
                'description' => 'Common questions about hiring our <strong>professional essay writers</strong>',
                'faqs' => [
                    [
                        'question' => 'How do you ensure the quality of your essay writers for hire?',
                        'answer' => 'We have a rigorous 6-step selection process that includes portfolio review, creative writing tasks, multilayered testing, and performance evaluation. Only 3% of applicants successfully complete our entire selection process. Additionally, we provide ongoing quality control, performance monitoring, and regular coaching to maintain high standards.',
                    ],
                    [
                        'question' => 'What qualifications do your professional academic writers have?',
                        'answer' => 'All our writers hold advanced degrees (Masters or PhD) from accredited universities. We have 312 PhD writers and 456 Masters-level writers across 100+ academic disciplines. Each writer undergoes credential verification and must demonstrate subject matter expertise in their field before joining our team.',
                    ],
                    [
                        'question' => 'Can I communicate directly with my assigned writer?',
                        'answer' => 'Yes! We provide direct communication channels between you and your assigned writer. You can ask questions, provide additional instructions, request updates, and discuss your paper throughout the writing process. This ensures your specific requirements are met and allows for real-time collaboration.',
                    ],
                    [
                        'question' => 'How do you match me with the right writer for my paper?',
                        'answer' => 'Our sophisticated matching system considers multiple factors: your subject area, academic level, paper type, deadline, and specific requirements. We match you with writers who have relevant expertise, experience with similar assignments, and availability to meet your timeline. This ensures the best possible fit for your academic needs.',
                    ],
                    [
                        'question' => 'What happens if I\'m not satisfied with my writer\'s work?',
                        'answer' => 'We offer unlimited free revisions to ensure your complete satisfaction. If you\'re not happy with the initial draft, your writer will make necessary changes based on your feedback. We also have a quality control team that reviews all work before delivery. In rare cases where issues persist, we can assign a different writer to your project.',
                    ],
                    [
                        'question' => 'Are your writers available for urgent deadlines?',
                        'answer' => 'Yes, many of our professional essay writers specialize in urgent assignments. We have writers available 24/7 who can handle deadlines as short as 3 hours while maintaining quality standards. Our quick assignment system ensures you get matched with an available expert writer immediately, even for last-minute orders.',
                    ],
                ]
            ]
        ]);

        // Block 9: Final CTA
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'writers_cta',
            'block_key' => 'writers_cta',
            'order' => 9,
            'is_active' => true,
            'content' => [
                'title' => 'Ready to Hire a Professional Essay Writer?',
                'description' => 'Join thousands of satisfied students who have achieved academic success with our expert writers. Get matched with the perfect writer for your needs today.',
                'primaryButtonText' => 'Hire a Writer Now',
                'primaryButtonLink' => '/place-order',
                'secondaryButtonText' => 'View Pricing',
                'secondaryButtonLink' => '/pricing',
                'trustBadges' => [
                    '847+ Expert Writers',
                    'PhD & Masters Degrees',
                    '99.2% On-Time Delivery',
                    'Unlimited Free Revisions',
                ]
            ]
        ]);

        $this->command->info('✅ Writers page created successfully with all content blocks!');
        $this->command->info('   - Hero with 7 stats');
        $this->command->info('   - 6-step selection process (interactive tabs)');
        $this->command->info('   - 3 writer superpowers');
        $this->command->info('   - 3 quality control features');
        $this->command->info('   - 5 client benefits');
        $this->command->info('   - 3 featured writer profiles');
        $this->command->info('   - 6 writer expertise points');
        $this->command->info('   - 6 FAQs');
        $this->command->info('   - Final CTA with trust badges');
    }
}




