<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;

class UpdateHomepageProductionURLsSeeder extends Seeder
{
    /**
     * Update homepage SEO URLs from localhost to production
     */
    public function run(): void
    {
        $this->command->info('Updating homepage SEO URLs to production...');

        $page = Page::where('slug', 'homepage')->first();

        if (!$page) {
            $this->command->error('Homepage not found!');
            return;
        }

        if (!$page->seo) {
            $this->command->error('Homepage SEO data not found!');
            return;
        }

        // Update basic SEO URLs
        $page->seo->update([
            'canonical_url' => 'https://academicscribe.com',
            'og_url' => 'https://academicscribe.com',
        ]);

        // Update structured data URLs
        $structuredData = $page->seo->structured_data;
        
        if ($structuredData) {
            // Convert to JSON string to do replacements
            $jsonString = json_encode($structuredData);
            
            // Replace localhost URLs with production
            $updatedJsonString = str_replace(
                [
                    'http://localhost',
                    'http:\\/\\/localhost',
                ],
                [
                    'https://academicscribe.com',
                    'https:\\/\\/academicscribe.com',
                ],
                $jsonString
            );
            
            // Convert back to array
            $updatedData = json_decode($updatedJsonString, true);
            
            // Update structured data
            $page->seo->update([
                'structured_data' => $updatedData
            ]);
        }

        $this->command->info('✅ Homepage SEO URLs updated to production successfully!');
        $this->command->info('Canonical URL: ' . $page->seo->canonical_url);
        $this->command->info('OG URL: ' . $page->seo->og_url);
    }
}

