import React from 'react';

export default function AboutAchievements({ title, description, achievements }) {
    if (!achievements || achievements.length === 0) return null;

    return (
        <section className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 dark:text-gray-300 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    {achievements.map((achievement, index) => (
                        <div
                            key={index}
                            className="bg-white dark:bg-gray-900 rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow"
                        >
                            <div className="text-4xl font-bold text-blue-600 dark:text-blue-400 mb-2">
                                {achievement.number}
                            </div>
                            <div className="text-xl font-semibold text-gray-900 dark:text-white mb-2">
                                {achievement.label}
                            </div>
                            <div className="text-gray-600 dark:text-gray-300">
                                {achievement.description}
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}




