import React from 'react';

export default function AboutProcess({ title, description, steps, ctaText, ctaLink }) {
    if (!steps || steps.length === 0) return null;

    return (
        <section className="py-16 bg-white dark:bg-gray-900">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 dark:text-gray-300 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
                    {steps.map((step, index) => (
                        <div key={index} className="text-center">
                            <div className="bg-blue-100 dark:bg-blue-900/30 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-6">
                                <span className="text-2xl font-bold text-blue-600 dark:text-blue-400">
                                    {step.number}
                                </span>
                            </div>
                            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-4">
                                {step.title}
                            </h3>
                            <div 
                                className="text-gray-600 dark:text-gray-300 content-area"
                                dangerouslySetInnerHTML={{ __html: step.description }}
                            />
                        </div>
                    ))}
                </div>

                {ctaText && ctaLink && (
                    <div className="text-center mt-12">
                        <a
                            href={ctaLink}
                            className="bg-blue-600 hover:bg-blue-700 dark:bg-blue-700 dark:hover:bg-blue-800 text-white px-8 py-4 rounded-lg font-bold text-lg transition-colors inline-block"
                        >
                            {ctaText}
                        </a>
                    </div>
                )}
            </div>
        </section>
    );
}




