import React from 'react';

export default function AboutServices({ title, description, services, ctaText, ctaLink }) {
    if (!services || services.length === 0) return null;

    return (
        <section className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 dark:text-gray-300 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    {services.map((service, index) => (
                        <div
                            key={index}
                            className="bg-white dark:bg-gray-900 rounded-lg shadow-sm p-6 hover:shadow-md transition-shadow border-t-4 border-blue-500 dark:border-blue-400"
                        >
                            <div className="text-3xl mb-4">{service.icon}</div>
                            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-3">
                                {service.title}
                            </h3>
                            <div 
                                className="text-gray-600 dark:text-gray-300 mb-4 content-area"
                                dangerouslySetInnerHTML={{ __html: service.description }}
                            />
                            <a
                                href={service.link || `/services/${service.title.toLowerCase().replace(/\s+/g, "-")}`}
                                className="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-semibold text-sm inline-flex items-center"
                            >
                                Learn More
                                <svg
                                    className="w-4 h-4 ml-1"
                                    fill="none"
                                    stroke="currentColor"
                                    viewBox="0 0 24 24"
                                >
                                    <path
                                        strokeLinecap="round"
                                        strokeLinejoin="round"
                                        strokeWidth={2}
                                        d="M9 5l7 7-7 7"
                                    />
                                </svg>
                            </a>
                        </div>
                    ))}
                </div>

                {ctaText && ctaLink && (
                    <div className="text-center mt-8">
                        <a
                            href={ctaLink}
                            className="bg-blue-600 hover:bg-blue-700 dark:bg-blue-700 dark:hover:bg-blue-800 text-white px-8 py-4 rounded-lg font-bold text-lg transition-colors inline-block"
                        >
                            {ctaText}
                        </a>
                    </div>
                )}
            </div>
        </section>
    );
}




