import React from 'react';
import { BookOpen, Users, Award } from 'lucide-react';

export default function AboutStory({ title, description, image, badge, linkText, linkUrl }) {
    if (!title) return null;

    return (
        <section className="py-16 bg-white dark:bg-gray-900">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    <div>
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
                            {title}
                        </h2>
                        <div 
                            className="text-gray-600 dark:text-gray-300 mb-6 content-area"
                            dangerouslySetInnerHTML={{ __html: description }}
                        />
                        {linkText && linkUrl && (
                            <a
                                href={linkUrl}
                                className="inline-flex items-center text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-semibold"
                            >
                                {linkText}
                                <svg
                                    className="w-4 h-4 ml-2"
                                    fill="none"
                                    stroke="currentColor"
                                    viewBox="0 0 24 24"
                                >
                                    <path
                                        strokeLinecap="round"
                                        strokeLinejoin="round"
                                        strokeWidth={2}
                                        d="M9 5l7 7-7 7"
                                    />
                                </svg>
                            </a>
                        )}
                    </div>
                    
                    {/* Hybrid Approach: Gradient on Mobile, Image on Desktop */}
                    <div className="relative">
                        {/* Mobile: Gradient with Icons */}
                        <div className="lg:hidden relative rounded-lg shadow-lg bg-gradient-to-br from-blue-500 via-indigo-500 to-purple-600 dark:from-blue-700 dark:via-indigo-700 dark:to-purple-800 p-12 min-h-[300px] flex items-center justify-center">
                            {/* Decorative Icons Grid */}
                            <div className="absolute inset-0 overflow-hidden rounded-lg">
                                <div className="absolute top-8 left-8 bg-white/10 rounded-full p-4">
                                    <BookOpen className="h-8 w-8 text-white" />
                                </div>
                                <div className="absolute top-1/3 right-8 bg-white/10 rounded-full p-4">
                                    <Users className="h-8 w-8 text-white" />
                                </div>
                                <div className="absolute bottom-8 left-1/3 bg-white/10 rounded-full p-4">
                                    <Award className="h-8 w-8 text-white" />
                                </div>
                            </div>
                            
                            {/* Center Content */}
                            <div className="relative text-center text-white z-10">
                                <div className="bg-white/20 backdrop-blur-md rounded-full p-8 inline-block">
                                    <BookOpen className="h-16 w-16" />
                                </div>
                                <p className="mt-4 text-lg font-semibold">Academic Excellence</p>
                            </div>
                            
                            {badge && (
                                <div className="absolute -bottom-6 -right-6 bg-blue-600 dark:bg-blue-700 text-white p-6 rounded-lg shadow-lg">
                                    <div className="text-2xl font-bold">{badge.value}</div>
                                    <div className="text-sm">{badge.label}</div>
                                </div>
                            )}
                        </div>

                        {/* Desktop: Lazy-loaded Image */}
                        <div className="hidden lg:block relative">
                            <img
                                src={image?.src || '/images/about-story.jpg'}
                                alt={image?.alt || 'Academic Scribe team working on academic writing projects'}
                                className="rounded-lg shadow-lg w-full"
                                loading="lazy"
                            />
                            {badge && (
                                <div className="absolute -bottom-6 -right-6 bg-blue-600 dark:bg-blue-700 text-white p-6 rounded-lg shadow-lg">
                                    <div className="text-2xl font-bold">{badge.value}</div>
                                    <div className="text-sm">{badge.label}</div>
                                </div>
                            )}
                        </div>
                    </div>
                </div>
            </div>
        </section>
    );
}




