import React from 'react';
import { Link } from '@inertiajs/react';
import { DollarSign, Clock, AlertCircle } from 'lucide-react';

export default function AdminWithdrawalWidget({ pendingWithdrawals, totalAmount }) {
    const formatCurrency = (amount) => {
        return new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD'
        }).format(amount);
    };

    return (
        <div className="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
            <div className="p-6">
                <div className="flex items-center justify-between mb-4">
                    <h3 className="text-lg font-semibold text-gray-900 dark:text-white">
                        Pending Withdrawals
                    </h3>
                    <Link
                        href="/admin/writer-withdrawals"
                        className="text-sm text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300"
                    >
                        View All →
                    </Link>
                </div>

                {pendingWithdrawals && pendingWithdrawals.length > 0 ? (
                    <div>
                        <div className="mb-4">
                            <div className="flex items-center text-2xl font-bold text-gray-900 dark:text-white">
                                <DollarSign size={24} className="text-green-500 mr-2" />
                                {formatCurrency(totalAmount)}
                            </div>
                            <p className="text-sm text-gray-600 dark:text-gray-400">
                                Total pending amount
                            </p>
                        </div>

                        <div className="space-y-3">
                            {pendingWithdrawals.slice(0, 3).map((withdrawal) => (
                                <div
                                    key={withdrawal.id}
                                    className="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700 rounded-md"
                                >
                                    <div className="flex items-center">
                                        <div className="w-8 h-8 bg-blue-100 dark:bg-blue-900 rounded-full flex items-center justify-center mr-3">
                                            <Clock size={16} className="text-blue-600 dark:text-blue-400" />
                                        </div>
                                        <div>
                                            <p className="text-sm font-medium text-gray-900 dark:text-white">
                                                {withdrawal.writer?.name || 'Unknown Writer'}
                                            </p>
                                            <p className="text-xs text-gray-500 dark:text-gray-400">
                                                {withdrawal.payment_method}
                                            </p>
                                        </div>
                                    </div>
                                    <div className="text-right">
                                        <p className="text-sm font-semibold text-gray-900 dark:text-white">
                                            {formatCurrency(withdrawal.requested_amount)}
                                        </p>
                                        <p className="text-xs text-gray-500 dark:text-gray-400">
                                            {new Date(withdrawal.created_at).toLocaleDateString()}
                                        </p>
                                    </div>
                                </div>
                            ))}
                        </div>

                        {pendingWithdrawals.length > 3 && (
                            <div className="mt-4 text-center">
                                <p className="text-sm text-gray-600 dark:text-gray-400">
                                    +{pendingWithdrawals.length - 3} more requests
                                </p>
                            </div>
                        )}
                    </div>
                ) : (
                    <div className="text-center py-8">
                        <AlertCircle size={48} className="text-gray-400 mx-auto mb-3" />
                        <p className="text-gray-500 dark:text-gray-400">
                            No pending withdrawal requests
                        </p>
                    </div>
                )}

                <div className="mt-6 pt-4 border-t border-gray-200 dark:border-gray-600">
                    <Link
                        href="/admin/writer-withdrawals"
                        className="w-full flex items-center justify-center px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition-colors duration-200"
                    >
                        Manage Withdrawals
                    </Link>
                </div>
            </div>
        </div>
    );
} 