import React from "react";
import OptimizedImage from "./OptimizedImage";
import PropTypes from "prop-types";

const Avatar = ({
    imageData,
    alt = "",
    size = "md",
    className = "",
    fallbackInitials = "",
    ...props
}) => {
    const sizeClasses = {
        xs: "w-8 h-8",
        sm: "w-12 h-12",
        md: "w-16 h-16",
        lg: "w-24 h-24",
        xl: "w-32 h-32",
    };

    const textSizeClasses = {
        xs: "text-xs",
        sm: "text-sm",
        md: "text-base",
        lg: "text-xl",
        xl: "text-2xl",
    };

    const sizeClass = sizeClasses[size] || sizeClasses.md;
    const textSizeClass = textSizeClasses[size] || textSizeClasses.md;

    // If no image data and we have initials, show initials
    if (!imageData && fallbackInitials) {
        return (
            <div
                className={`
                ${sizeClass}
                rounded-full
                bg-blue-500
                text-white
                flex
                items-center
                justify-center
                font-semibold
                ${textSizeClass}
                ${className}
            `}
            >
                {fallbackInitials}
            </div>
        );
    }

    return (
        <div
            className={`${sizeClass} rounded-full overflow-hidden ${className}`}
        >
            <OptimizedImage
                imageData={imageData}
                alt={alt}
                className="w-full h-full object-cover"
                sizes="150px" // Avatars are typically small
                {...props}
            />
        </div>
    );
};

Avatar.propTypes = {
    imageData: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),
    alt: PropTypes.string,
    size: PropTypes.oneOf(["xs", "sm", "md", "lg", "xl"]),
    className: PropTypes.string,
    fallbackInitials: PropTypes.string,
};

export default Avatar;
