import React from 'react';
import { BookOpen, Users, Award, CheckCircle } from 'lucide-react';

export default function AboutBlock({ content }) {
    if (!content) {
        return null;
    }

    return (
        <section className="relative py-20 bg-gradient-to-br from-gray-50 to-blue-50 dark:from-gray-900 dark:to-gray-800 overflow-hidden">
            {/* Background Pattern */}
            <div className="absolute inset-0 bg-grid-pattern opacity-10"></div>
            
            {/* Decorative Background Elements */}
            <div className="absolute top-20 left-10 w-64 h-64 bg-blue-200/30 dark:bg-white/10 rounded-full blur-3xl animate-blob"></div>
            <div className="absolute bottom-20 right-10 w-80 h-80 bg-purple-200/30 dark:bg-white/10 rounded-full blur-3xl animate-blob animation-delay-2000"></div>
            <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-96 h-96 bg-indigo-200/30 dark:bg-white/10 rounded-full blur-3xl animate-blob animation-delay-4000"></div>

            {/* Content - Full Width Centered */}
            <div className="relative max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <div className="space-y-10">
                    {/* Top: Title */}
                    <div className="space-y-4">
                        <h2 className="text-4xl sm:text-5xl lg:text-6xl font-bold text-gray-900 dark:text-white leading-tight">
                            {content.title}
                        </h2>
                    </div>

                    {/* Center: Description and Mission */}
                    <div className="space-y-8">
                        {content.description && (
                            <div
                                className="content-area text-lg sm:text-xl text-gray-700 dark:text-gray-300 leading-relaxed max-w-3xl mx-auto prose prose-lg dark:prose-invert max-w-none"
                                dangerouslySetInnerHTML={{ __html: content.description }}
                            />
                        )}

                        {content.mission_title && content.mission_description && (
                            <div className="space-y-4 bg-gradient-to-r from-blue-600 to-purple-600 dark:from-blue-800 dark:to-purple-900 rounded-2xl p-8 max-w-3xl mx-auto shadow-lg">
                                <h3 className="text-2xl sm:text-3xl font-semibold text-white flex items-center justify-center gap-3">
                                    <Award className="h-8 w-8 text-yellow-300" />
                                    {content.mission_title}
                                </h3>
                                <div
                                    className="content-area text-white/90 prose prose-lg prose-invert max-w-none"
                                    dangerouslySetInnerHTML={{ __html: content.mission_description }}
                                />
                            </div>
                        )}
                    </div>

                    {/* Bottom: Features Grid */}
                    {content.features && content.features.length > 0 && (
                        <div className="grid sm:grid-cols-2 lg:grid-cols-2 gap-6 max-w-4xl mx-auto pt-8">
                            {content.features.map((feature, index) => (
                                <div key={index} className="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-xl p-6 text-left space-y-3 hover:shadow-lg transition-all duration-200">
                                    <div className="flex items-start gap-3">
                                        <CheckCircle className="h-6 w-6 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-1" />
                                        <div className="flex-1">
                                            <h4
                                                className="content-area font-semibold text-gray-900 dark:text-white text-lg mb-2"
                                                dangerouslySetInnerHTML={{ __html: feature.title }}
                                            />
                                            <p className="text-gray-700 dark:text-gray-300">
                                                {feature.description}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            ))}
                        </div>
                    )}
                </div>
            </div>
        </section>
    );
}

