import React from 'react';
import { Link } from '@inertiajs/react';
import { ArrowRight, CheckCircle, Star, Users, Award, Clock } from 'lucide-react';

export default function HeroBlock({ content }) {
    // Strictly database-driven: no hardcoded defaults. Render only what CMS provides.
    const headlinePrimary = content?.headlinePrimary;
    const headlineHighlight = content?.headlineHighlight;
    const headlineSuffix = content?.headlineSuffix;
    const trustText = content?.trustText;
    const paragraph = content?.paragraph;
    const bullet1 = content?.bullet1;
    const bullet2 = content?.bullet2;
    const bullet3 = content?.bullet3;
    const bullet4 = content?.bullet4;
    const ctaPrimaryText = content?.ctaPrimaryText;
    const ctaPrimaryHref = content?.ctaPrimaryHref;
    const ctaSecondaryText = content?.ctaSecondaryText;
    const ctaSecondaryHref = content?.ctaSecondaryHref;
    const stat1Value = content?.stat1Value;
    const stat1Label = content?.stat1Label;
    const stat2Value = content?.stat2Value;
    const stat2Label = content?.stat2Label;
    const stat3Value = content?.stat3Value;
    const stat3Label = content?.stat3Label;

    return (
        <section className="relative bg-gradient-to-r from-blue-900 to-cyan-500 dark:from-gray-900 dark:to-gray-800 pt-20 pb-16 overflow-hidden">
            {/* Background Pattern */}
            <div className="absolute inset-0 bg-grid-pattern opacity-10"></div>
            
            {/* Decorative Background Elements */}
            <div className="absolute top-20 left-10 w-72 h-72 bg-white/10 rounded-full blur-3xl animate-blob"></div>
            <div className="absolute top-40 right-10 w-96 h-96 bg-white/10 rounded-full blur-3xl animate-blob animation-delay-2000"></div>
            <div className="absolute bottom-20 left-1/3 w-80 h-80 bg-white/10 rounded-full blur-3xl animate-blob animation-delay-4000"></div>

            {/* Content - Full Width Centered */}
            <div className="relative max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <div className="space-y-10 py-12">
                    {/* Top: Trust Badge and Heading */}
                    <div className="space-y-6">
                        {/* Trust Badge */}
                        {trustText && (
                            <div className="flex items-center justify-center space-x-2 text-sm">
                                <div className="flex items-center space-x-1">
                                    <Star className="h-5 w-5 text-cyan-300 fill-current" />
                                    <Star className="h-5 w-5 text-cyan-300 fill-current" />
                                    <Star className="h-5 w-5 text-cyan-300 fill-current" />
                                    <Star className="h-5 w-5 text-cyan-300 fill-current" />
                                    <Star className="h-5 w-5 text-cyan-300 fill-current" />
                                </div>
                                <span className="text-white/90">{trustText}</span>
                            </div>
                        )}

                        {/* Main Headline */}
                        {(headlinePrimary || headlineHighlight || headlineSuffix) && (
                            <h1 className="text-4xl sm:text-5xl lg:text-6xl xl:text-7xl font-bold text-white leading-tight">
                                {headlinePrimary && (<span>{headlinePrimary} </span>)}
                                {headlineHighlight && (<span className="text-cyan-300">{headlineHighlight}</span>)}
                                {headlineSuffix && (<span> {headlineSuffix}</span>)}
                            </h1>
                        )}
                    </div>

                    {/* Center: Description and Benefits */}
                    <div className="space-y-8">
                        {paragraph && (
                            <div 
                                className="text-lg sm:text-xl text-white/90 leading-relaxed max-w-3xl mx-auto prose prose-lg prose-invert max-w-none"
                                dangerouslySetInnerHTML={{ __html: paragraph }}
                            />
                        )}

                        {/* Key Benefits */}
                        {(bullet1 || bullet2 || bullet3 || bullet4) && (
                            <div className="grid sm:grid-cols-2 lg:grid-cols-4 gap-4 max-w-4xl mx-auto">
                                {bullet1 && (
                                    <div className="flex items-center justify-center space-x-2 bg-white/10 backdrop-blur-sm rounded-lg p-3">
                                        <CheckCircle className="h-5 w-5 text-green-300 flex-shrink-0" />
                                        <span className="text-white text-sm sm:text-base">{bullet1}</span>
                                    </div>
                                )}
                                {bullet2 && (
                                    <div className="flex items-center justify-center space-x-2 bg-white/10 backdrop-blur-sm rounded-lg p-3">
                                        <CheckCircle className="h-5 w-5 text-green-300 flex-shrink-0" />
                                        <span className="text-white text-sm sm:text-base">{bullet2}</span>
                                    </div>
                                )}
                                {bullet3 && (
                                    <div className="flex items-center justify-center space-x-2 bg-white/10 backdrop-blur-sm rounded-lg p-3">
                                        <CheckCircle className="h-5 w-5 text-green-300 flex-shrink-0" />
                                        <span className="text-white text-sm sm:text-base">{bullet3}</span>
                                    </div>
                                )}
                                {bullet4 && (
                                    <div className="flex items-center justify-center space-x-2 bg-white/10 backdrop-blur-sm rounded-lg p-3">
                                        <CheckCircle className="h-5 w-5 text-green-300 flex-shrink-0" />
                                        <span className="text-white text-sm sm:text-base">{bullet4}</span>
                                    </div>
                                )}
                            </div>
                        )}
                    </div>

                    {/* Bottom: CTAs and Stats */}
                    <div className="space-y-10">
                        {/* CTA Buttons */}
                        {(ctaPrimaryText || ctaSecondaryText) && (
                            <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
                                {ctaPrimaryText && ctaPrimaryHref && (
                                    <Link
                                        href={ctaPrimaryHref}
                                        className="inline-flex items-center justify-center px-8 py-4 text-lg font-semibold text-blue-700 bg-white hover:bg-gray-100 rounded-lg transition-all duration-200 shadow-xl hover:shadow-2xl transform hover:-translate-y-1"
                                    >
                                        {ctaPrimaryText}
                                        <ArrowRight className="ml-2 h-5 w-5" />
                                    </Link>
                                )}
                                {ctaSecondaryText && ctaSecondaryHref && (
                                    <Link
                                        href={ctaSecondaryHref}
                                        className="inline-flex items-center justify-center px-8 py-4 text-lg font-semibold text-white bg-white/20 backdrop-blur-sm border-2 border-white/40 hover:bg-white/30 rounded-lg transition-all duration-200"
                                    >
                                        {ctaSecondaryText}
                                    </Link>
                                )}
                            </div>
                        )}

                        {/* Quick Stats */}
                        {(stat1Value || stat2Value || stat3Value) && (
                            <div className="grid grid-cols-3 gap-8 max-w-3xl mx-auto pt-8 border-t border-white/20">
                                {(stat1Value || stat1Label) && (
                                    <div className="text-center">
                                        <div className="flex items-center justify-center mb-2">
                                            <Users className="h-8 w-8 text-cyan-300" />
                                        </div>
                                        {stat1Value && (<div className="text-3xl sm:text-4xl font-bold text-white">{stat1Value}</div>)}
                                        {stat1Label && (<div className="text-sm text-white/80 mt-1">{stat1Label}</div>)}
                                    </div>
                                )}
                                {(stat2Value || stat2Label) && (
                                    <div className="text-center">
                                        <div className="flex items-center justify-center mb-2">
                                            <Award className="h-8 w-8 text-cyan-300" />
                                        </div>
                                        {stat2Value && (<div className="text-3xl sm:text-4xl font-bold text-white">{stat2Value}</div>)}
                                        {stat2Label && (<div className="text-sm text-white/80 mt-1">{stat2Label}</div>)}
                                    </div>
                                )}
                                {(stat3Value || stat3Label) && (
                                    <div className="text-center">
                                        <div className="flex items-center justify-center mb-2">
                                            <Clock className="h-8 w-8 text-cyan-300" />
                                        </div>
                                        {stat3Value && (<div className="text-3xl sm:text-4xl font-bold text-white">{stat3Value}</div>)}
                                        {stat3Label && (<div className="text-sm text-white/80 mt-1">{stat3Label}</div>)}
                                    </div>
                                )}
                            </div>
                        )}
                    </div>
                </div>
            </div>
        </section>
    );
}
