import React from 'react';

export default function OverviewBlock({ content }) {
    if (!content) return null;

    const {
        title = '',
        description = '',
        features = [],
        image = ''
    } = content;

    return (
        <section className="overview-section py-16 bg-white">
            <div className="container mx-auto px-4">
                <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    {/* Content */}
                    <div>
                        {title && (
                            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">
                                {title}
                            </h2>
                        )}
                        
                        {description && (
                            <div 
                                className="text-lg text-gray-600 dark:text-gray-300 mb-8 leading-relaxed prose prose-lg dark:prose-invert max-w-none"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                        
                        {features && features.length > 0 && (
                            <div className="space-y-4">
                                {features.map((feature, index) => (
                                    <div key={index} className="flex items-start space-x-3">
                                        <div className="flex-shrink-0 w-6 h-6 bg-green-500 rounded-full flex items-center justify-center mt-1">
                                            <svg className="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 20 20">
                                                <path fillRule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clipRule="evenodd" />
                                            </svg>
                                        </div>
                                        <div>
                                            <h3 className="font-semibold text-gray-900">{feature.title || feature}</h3>
                                            {feature.description && (
                                                <p className="text-gray-600 mt-1">{feature.description}</p>
                                            )}
                                        </div>
                                    </div>
                                ))}
                            </div>
                        )}
                    </div>
                    
                    {/* Image */}
                    {image && (
                        <div className="relative">
                            <img
                                src={image}
                                alt={title || 'Overview'}
                                className="w-full h-auto rounded-lg shadow-lg"
                            />
                        </div>
                    )}
                </div>
            </div>
        </section>
    );
}
