import React from 'react';
import { Button } from '@/Components/ui/Button';

export default function PricingBlock({ content }) {
    if (!content) return null;

    const {
        title = '',
        subtitle = '',
        plans = []
    } = content;

    return (
        <section className="pricing-section py-16 bg-gray-50">
            <div className="container mx-auto px-4">
                <div className="text-center mb-12">
                    {title && (
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                            {title}
                        </h2>
                    )}
                    
                    {subtitle && (
                        <p className="text-lg text-gray-600 max-w-2xl mx-auto">
                            {subtitle}
                        </p>
                    )}
                </div>
                
                {plans && plans.length > 0 && (
                    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto">
                        {plans.map((plan, index) => (
                            <div 
                                key={index} 
                                className={`bg-white rounded-lg shadow-lg p-8 relative ${
                                    plan.featured ? 'ring-2 ring-blue-500 transform scale-105' : ''
                                }`}
                            >
                                {plan.featured && (
                                    <div className="absolute -top-4 left-1/2 transform -translate-x-1/2">
                                        <span className="bg-blue-500 text-white px-4 py-1 rounded-full text-sm font-semibold">
                                            Most Popular
                                        </span>
                                    </div>
                                )}
                                
                                <div className="text-center mb-6">
                                    <h3 className="text-2xl font-bold text-gray-900 mb-2">
                                        {plan.name}
                                    </h3>
                                    
                                    <div className="mb-4">
                                        <span className="text-4xl font-bold text-gray-900">
                                            ${plan.price}
                                        </span>
                                        {plan.period && (
                                            <span className="text-gray-600 ml-1">
                                                /{plan.period}
                                            </span>
                                        )}
                                    </div>
                                    
                                    {plan.description && (
                                        <p className="text-gray-600">
                                            {plan.description}
                                        </p>
                                    )}
                                </div>
                                
                                {plan.features && plan.features.length > 0 && (
                                    <ul className="space-y-3 mb-8">
                                        {plan.features.map((feature, featureIndex) => (
                                            <li key={featureIndex} className="flex items-center">
                                                <svg className="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fillRule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clipRule="evenodd" />
                                                </svg>
                                                <span className="text-gray-700">{feature}</span>
                                            </li>
                                        ))}
                                    </ul>
                                )}
                                
                                {plan.button_text && plan.button_link && (
                                    <div className="text-center">
                                        <Button 
                                            asChild
                                            className={`w-full ${
                                                plan.featured 
                                                    ? 'bg-blue-600 hover:bg-blue-700 text-white' 
                                                    : 'bg-gray-100 hover:bg-gray-200 text-gray-900'
                                            }`}
                                        >
                                            <a href={plan.button_link}>
                                                {plan.button_text}
                                            </a>
                                        </Button>
                                    </div>
                                )}
                            </div>
                        ))}
                    </div>
                )}
            </div>
        </section>
    );
}
