import React from 'react';

export default function TextContentBlock({ content }) {
    if (!content) return null;

    const {
        title = '',
        content: textContent = '',
        layout = 'single_column'
    } = content;

    const renderContent = () => {
        if (typeof textContent === 'string') {
            // Simple HTML rendering (be careful with XSS in production)
            return (
                <div 
                    className="content-area prose prose-lg max-w-none"
                    dangerouslySetInnerHTML={{ __html: textContent }}
                />
            );
        } else if (Array.isArray(textContent)) {
            // Array of content blocks
            return (
                <div className="space-y-6">
                    {textContent.map((block, index) => (
                        <div key={index} className="content-area prose prose-lg max-w-none">
                            {block.title && (
                                <h3 className="text-xl font-semibold text-gray-900 mb-3">
                                    {block.title}
                                </h3>
                            )}
                            <div 
                                dangerouslySetInnerHTML={{ __html: block.content || block.text }}
                            />
                        </div>
                    ))}
                </div>
            );
        }
        
        return null;
    };

    const getLayoutClass = () => {
        switch (layout) {
            case 'two_column':
                return 'grid grid-cols-1 lg:grid-cols-2 gap-8';
            case 'three_column':
                return 'grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8';
            case 'single_column':
            default:
                return 'max-w-4xl mx-auto';
        }
    };

    return (
        <section className="text-content-section py-16 bg-white">
            <div className="container mx-auto px-4">
                <div className={getLayoutClass()}>
                    {title && (
                        <div className="text-center mb-12">
                            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                                {title}
                            </h2>
                        </div>
                    )}
                    
                    {renderContent()}
                </div>
            </div>
        </section>
    );
}
