import React from "react";
import { router } from "@inertiajs/react";

const CleanPagination = ({ links, total, perPage, currentPage }) => {
    if (!links || links.length <= 3) {
        return null;
    }

    const navigate = (url) => {
        if (url) {
            router.get(url, {}, { preserveScroll: true, preserveState: true });
        }
    };

    const start = (currentPage - 1) * perPage + 1;
    const end = Math.min(start + perPage - 1, total);

    // Extract the inner links (excluding first and last which are prev/next)
    const innerLinks = links.slice(1, -1);

    return (
        <div className="mb-2 mt-2">
            <nav className="flex flex-col sm:flex-row items-center justify-between px-2 sm:px-4 py-2 sm:py-3 bg-white dark:bg-gray-800 rounded-lg shadow dark:shadow-gray-700 transition-colors">
                {/* Showing X - Y out of Z results */}
                <div className="text-xs sm:text-sm text-gray-600 dark:text-gray-300 mb-3 sm:mb-0">
                    {`Showing ${start} - ${end} out of ${total} results`}
                </div>

                {/* Pagination Controls */}
                <div className="flex flex-wrap items-center gap-1 sm:gap-2 justify-center">
                    {/* Previous Button */}
                    {links[0].url && (
                        <button
                            className="px-2 py-1 text-xs sm:text-sm text-gray-900 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 rounded transition-colors"
                            onClick={() => navigate(links[0].url)}
                        >
                            Previous
                        </button>
                    )}

                    {/* Page Numbers */}
                    {innerLinks.map((link, index) => (
                        <span
                            key={index}
                            className={`px-2 py-1 text-xs sm:text-sm rounded cursor-pointer whitespace-nowrap ${
                                link.active
                                    ? "bg-primary-50 dark:bg-primary-900 text-primary-600 dark:text-primary-400"
                                    : "text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700"
                            }`}
                            onClick={() => navigate(link.url)}
                            dangerouslySetInnerHTML={{ __html: link.label }}
                        />
                    ))}

                    {/* Next Button */}
                    {links[links.length - 1].url && (
                        <button
                            className="px-2 py-1 text-xs sm:text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 rounded transition-colors"
                            onClick={() =>
                                navigate(links[links.length - 1].url)
                            }
                        >
                            Next
                        </button>
                    )}
                </div>
            </nav>
        </div>
    );
};

export default CleanPagination;
