import React, { useState, useEffect } from "react";
import { Clock } from "lucide-react";

export default function DashboardDeadlineCountdown({
    deadline,
    isLate = false,
}) {
    const [timeRemaining, setTimeRemaining] = useState(null);

    useEffect(() => {
        if (!deadline) return;

        const calculateTimeRemaining = () => {
            const now = new Date().getTime();
            const deadlineTime = new Date(deadline).getTime();
            const difference = deadlineTime - now;

            if (difference <= 0) {
                // Past deadline
                const absDifference = Math.abs(difference);
                const days = Math.floor(absDifference / (1000 * 60 * 60 * 24));
                const hours = Math.floor(
                    (absDifference % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)
                );

                setTimeRemaining({
                    isPast: true,
                    text:
                        days > 0 ? `${days}d ${hours}h late` : `${hours}h late`,
                });
            } else {
                // Before deadline
                const days = Math.floor(difference / (1000 * 60 * 60 * 24));
                const hours = Math.floor(
                    (difference % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)
                );

                setTimeRemaining({
                    isPast: false,
                    text:
                        days > 0 ? `${days}d ${hours}h left` : `${hours}h left`,
                });
            }
        };

        calculateTimeRemaining();
        const timer = setInterval(calculateTimeRemaining, 60000); // Update every minute

        return () => clearInterval(timer);
    }, [deadline]);

    if (!timeRemaining) return null;

    return (
        <div
            className={`flex items-center gap-1 text-xs ${
                timeRemaining.isPast
                    ? "text-red-600 dark:text-red-400"
                    : "text-gray-600 dark:text-gray-400"
            }`}
        >
            <Clock size={14} />
            <span>{timeRemaining.text}</span>
        </div>
    );
}
