import React from 'react';

export default function GuaranteeHero({ hero }) {
    if (!hero) return null;

    return (
        <div className="bg-gradient-to-r from-blue-600 to-indigo-700 dark:from-blue-800 dark:to-indigo-900 text-white py-16 md:py-24">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center">
                    <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-4">
                        {hero.title}
                    </h1>
                    {hero.subtitle && (
                        <p className="text-xl md:text-2xl text-blue-100 mb-6">
                            {hero.subtitle}
                        </p>
                    )}
                    <div 
                        className="text-lg md:text-xl max-w-3xl mx-auto text-blue-50 content-area"
                        dangerouslySetInnerHTML={{ __html: hero.description }}
                    />
                </div>
            </div>
        </div>
    );
}





