import React from 'react';
import { Link } from '@inertiajs/react';

export default function QualityStandards({ title, description, standards }) {
    if (!standards || standards.length === 0) return null;

    return (
        <div className="bg-gray-50 dark:bg-gray-900 py-16 md:py-20">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <h2 className="text-3xl md:text-4xl font-bold text-center text-gray-900 dark:text-white mb-4">
                        {title}
                    </h2>
                )}
                {description && (
                    <div 
                        className="text-lg text-center text-gray-600 dark:text-gray-300 mb-12 max-w-3xl mx-auto content-area"
                        dangerouslySetInnerHTML={{ __html: description }}
                    />
                )}
                
                <div className="grid md:grid-cols-2 gap-8">
                    {standards.map((standard, index) => (
                        <div 
                            key={index} 
                            className="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6 hover:shadow-lg transition-shadow duration-300"
                        >
                            {standard.icon && (
                                <div className="text-4xl mb-3">{standard.icon}</div>
                            )}
                            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-3">
                                {standard.title}
                            </h3>
                            <div 
                                className="text-gray-600 dark:text-gray-300 mb-4 content-area"
                                dangerouslySetInnerHTML={{ __html: standard.description }}
                            />
                            
                            {standard.features && standard.features.length > 0 && (
                                <ul className="space-y-2 mb-4">
                                    {standard.features.map((feature, idx) => (
                                        <li key={idx} className="flex items-start">
                                            <span className="text-green-500 mr-2 mt-1">✓</span>
                                            <span className="text-gray-700 dark:text-gray-300">{feature}</span>
                                        </li>
                                    ))}
                                </ul>
                            )}
                            
                            {standard.link && standard.linkText && (
                                <Link
                                    href={standard.link}
                                    className="inline-flex items-center text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-medium transition-colors"
                                >
                                    {standard.linkText} →
                                </Link>
                            )}
                        </div>
                    ))}
                </div>
            </div>
        </div>
    );
}





