import { Link } from "@inertiajs/react";
import {
    ArrowRight,
    CheckCircle,
    Star,
    Users,
    Award,
    Clock,
} from "lucide-react";
import OptimizedImage from "./OptimizedImage";

export default function Hero() {
    return (
        <section className="relative bg-gradient-to-br from-blue-50 via-white to-blue-100 dark:from-gray-900 dark:via-gray-800 dark:to-blue-900 pt-20 pb-16 overflow-hidden">
            {/* Background Pattern */}
            <div className="absolute inset-0 bg-grid-pattern opacity-5"></div>

            <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="grid lg:grid-cols-2 gap-12 items-center">
                    {/* Left Content */}
                    <div className="space-y-8">
                        {/* Trust Badge */}
                        <div className="flex items-center space-x-2 text-sm">
                            <div className="flex items-center space-x-1">
                                <Star className="h-4 w-4 text-yellow-400 fill-current" />
                                <Star className="h-4 w-4 text-yellow-400 fill-current" />
                                <Star className="h-4 w-4 text-yellow-400 fill-current" />
                                <Star className="h-4 w-4 text-yellow-400 fill-current" />
                                <Star className="h-4 w-4 text-yellow-400 fill-current" />
                            </div>
                            <span className="text-gray-600 dark:text-gray-300">
                                Trusted by 10,000+ students worldwide
                            </span>
                        </div>

                        {/* Main Headline */}
                        <div className="space-y-4">
                            <h1 className="text-4xl sm:text-5xl lg:text-6xl font-bold text-gray-900 dark:text-white leading-tight">
                                Professional{" "}
                                <span className="text-blue-600 dark:text-blue-400">
                                    Academic Writing Services
                                </span>{" "}
                                for Students Worldwide
                            </h1>
                            <p className="text-xl text-gray-600 dark:text-gray-300 leading-relaxed">
                                Leading academic writing company providing expert essay writers and 
                                dissertation writing help. Our professional academic writing service 
                                delivers custom assignments, research papers, and essays for students 
                                worldwide with guaranteed quality and originality.
                            </p>
                        </div>

                        {/* Key Benefits */}
                        <div className="grid sm:grid-cols-2 gap-4">
                            <div className="flex items-center space-x-3">
                                <CheckCircle className="h-5 w-5 text-green-500 flex-shrink-0" />
                                <span className="text-gray-700 dark:text-gray-300">
                                    Trusted academic writing company
                                </span>
                            </div>
                            <div className="flex items-center space-x-3">
                                <CheckCircle className="h-5 w-5 text-green-500 flex-shrink-0" />
                                <span className="text-gray-700 dark:text-gray-300">
                                    100% original content
                                </span>
                            </div>
                            <div className="flex items-center space-x-3">
                                <CheckCircle className="h-5 w-5 text-green-500 flex-shrink-0" />
                                <span className="text-gray-700 dark:text-gray-300">
                                    24/7 customer support
                                </span>
                            </div>
                            <div className="flex items-center space-x-3">
                                <CheckCircle className="h-5 w-5 text-green-500 flex-shrink-0" />
                                <span className="text-gray-700 dark:text-gray-300">
                                    On-time delivery guaranteed
                                </span>
                            </div>
                        </div>

                        {/* CTA Buttons */}
                        <div className="flex flex-col sm:flex-row gap-4">
                            <Link
                                href="/place-order"
                                className="inline-flex items-center justify-center px-8 py-4 text-lg font-semibold text-white bg-blue-600 hover:bg-blue-700 dark:bg-blue-700 dark:hover:bg-blue-800 rounded-lg transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-1"
                            >
                                Get Started Now
                                <ArrowRight className="ml-2 h-5 w-5" />
                            </Link>
                            <Link
                                href="/services"
                                className="inline-flex items-center justify-center px-8 py-4 text-lg font-semibold text-blue-600 dark:text-blue-400 bg-white dark:bg-gray-800 border-2 border-blue-600 dark:border-blue-400 hover:bg-blue-50 dark:hover:bg-blue-900/30 rounded-lg transition-all duration-200"
                            >
                                View Services
                            </Link>
                        </div>

                        {/* Quick Stats */}
                        <div className="grid grid-cols-3 gap-6 pt-8 border-t border-gray-200 dark:border-gray-700">
                            <div className="text-center">
                                <div className="flex items-center justify-center mb-2">
                                    <Users className="h-6 w-6 text-blue-600 dark:text-blue-400" />
                                </div>
                                <div className="text-2xl font-bold text-gray-900 dark:text-white">
                                    10K+
                                </div>
                                <div className="text-sm text-gray-600 dark:text-gray-400">
                                    Happy Students
                                </div>
                            </div>
                            <div className="text-center">
                                <div className="flex items-center justify-center mb-2">
                                    <Award className="h-6 w-6 text-blue-600 dark:text-blue-400" />
                                </div>
                                <div className="text-2xl font-bold text-gray-900 dark:text-white">
                                    98%
                                </div>
                                <div className="text-sm text-gray-600 dark:text-gray-400">
                                    Success Rate
                                </div>
                            </div>
                            <div className="text-center">
                                <div className="flex items-center justify-center mb-2">
                                    <Clock className="h-6 w-6 text-blue-600 dark:text-blue-400" />
                                </div>
                                <div className="text-2xl font-bold text-gray-900 dark:text-white">
                                    24/7
                                </div>
                                <div className="text-sm text-gray-600 dark:text-gray-400">
                                    Support
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* ✅ Right Side - Optimized Hero Image */}
                    <div className="relative lg:order-last order-first">
                        <div className="relative">
                            {/* Main Hero Image - Now Optimized */}
                            <div className="relative rounded-2xl overflow-hidden shadow-2xl">
                                <OptimizedImage
                                    src="/images/hero-academic-writers.jpg"
                                    alt="Professional essay writers providing dissertation writing help and research paper writing service for custom academic papers - Academic writing services team"
                                    className="w-full h-[400px] sm:h-[500px] lg:h-[600px] object-cover"
                                    priority={true}
                                    width={600}
                                    height={600}
                                    sizes="(max-width: 768px) 100vw, (max-width: 1024px) 50vw, 600px"
                                />

                                {/* Image Overlay for Better Text Contrast */}
                                <div className="absolute inset-0 bg-gradient-to-t from-black/20 via-transparent to-transparent"></div>

                                {/* Floating Achievement Badge */}
                                <div className="absolute top-6 left-6 bg-white/95 dark:bg-gray-800/95 backdrop-blur-sm rounded-lg p-4 shadow-lg">
                                    <div className="flex items-center space-x-2">
                                        <div className="flex text-yellow-400">
                                            <Star className="h-4 w-4 fill-current" />
                                            <Star className="h-4 w-4 fill-current" />
                                            <Star className="h-4 w-4 fill-current" />
                                            <Star className="h-4 w-4 fill-current" />
                                            <Star className="h-4 w-4 fill-current" />
                                        </div>
                                    </div>
                                    <div className="text-sm font-semibold text-gray-900 dark:text-white">
                                        4.9/5 Rating
                                    </div>
                                    <div className="text-xs text-gray-600 dark:text-gray-400">
                                        1,200+ Reviews
                                    </div>
                                </div>

                                {/* Floating Success Badge */}
                                <div className="absolute bottom-6 right-6 bg-green-500/95 backdrop-blur-sm rounded-lg p-4 shadow-lg text-white">
                                    <div className="flex items-center space-x-2">
                                        <CheckCircle className="h-5 w-5" />
                                        <div>
                                            <div className="text-sm font-semibold">
                                                98% Success Rate
                                            </div>
                                            <div className="text-xs opacity-90">
                                                Guaranteed Quality
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {/* Decorative Elements - Constrained to prevent overflow */}
                            <div className="absolute top-0 right-0 w-24 h-24 bg-blue-200 dark:bg-blue-800 rounded-full opacity-20 animate-pulse"></div>
                            <div className="absolute bottom-0 left-0 w-32 h-32 bg-purple-200 dark:bg-purple-800 rounded-full opacity-20 animate-pulse delay-1000"></div>
                        </div>
                    </div>
                </div>
            </div>

            {/* Background Decorative Elements - Constrained to prevent overflow */}
            <div className="absolute top-1/4 left-4 w-64 h-64 bg-blue-300 dark:bg-blue-700 rounded-full mix-blend-multiply dark:mix-blend-screen filter blur-xl opacity-20 animate-blob"></div>
            <div className="absolute top-1/3 right-4 w-64 h-64 bg-purple-300 dark:bg-purple-700 rounded-full mix-blend-multiply dark:mix-blend-screen filter blur-xl opacity-20 animate-blob animation-delay-2000"></div>
            <div className="absolute bottom-1/4 left-1/3 w-64 h-64 bg-pink-300 dark:bg-pink-700 rounded-full mix-blend-multiply dark:mix-blend-screen filter blur-xl opacity-20 animate-blob animation-delay-4000"></div>
        </section>
    );
}
