import { Link } from "@inertiajs/react";

export default function NavLink({
    active = false,
    className = "",
    children,
    ...props
}) {
    return (
        <Link
            {...props}
            className={
                "inline-flex items-center border-b-2 px-1 pt-1 text-sm font-medium leading-5 transition duration-150 ease-in-out focus:outline-none " +
                (active
                    ? "border-indigo-400 text-gray-100 dark:text-white focus:border-indigo-700"
                    : "border-transparent text-gray-100 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-200 hover:border-gray-300 dark:hover:border-gray-500 focus:text-gray-700 dark:focus:text-gray-200 focus:border-gray-300 dark:focus:border-gray-500") +
                className
            }
        >
            {children}
        </Link>
    );
}
