import React from "react";
import { AlertCircle } from "lucide-react";

const ValidationErrors = ({ errors }) => {
    // If there are no errors, don't render anything
    if (!errors || Object.keys(errors).length === 0) {
        return null;
    }

    return (
        <div className="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4 mb-6">
            <div className="flex">
                <div className="flex-shrink-0">
                    <AlertCircle
                        className="h-5 w-5 text-red-500"
                        aria-hidden="true"
                    />
                </div>
                <div className="ml-3">
                    <h3 className="text-sm font-medium text-red-800 dark:text-red-300">
                        Please fix the following errors:
                    </h3>
                    <div className="mt-2 text-sm text-red-700 dark:text-red-400">
                        <ul className="list-disc pl-5 space-y-1">
                            {Object.entries(errors).map(([field, message]) => (
                                <li key={field}>{message}</li>
                            ))}
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default ValidationErrors;
