import { Card } from "./ui/Card";

export function OrderPreview({
    data,
    totalAmount,
    basePrice,
    costPerPage,
    costPerSlide,
    netAmount,
    discount,
}) {
    return (
        <>
            {/* Sticky Order Preview - Top Right */}
            <div className="hidden lg:block fixed top-20 right-6 w-80 xl:w-96 z-40 max-h-[calc(100vh-5rem)] overflow-y-auto">
                <Card className="p-6 shadow-lg">
                    <h2 className="text-md font-semibold mb-4 dark:text-gray-100">
                        Order Preview
                    </h2>
                    <div className="space-y-4">
                        <div>
                            <p className="text-md font-semibold text-gray-900">
                                Title
                            </p>
                            <p className="text-sm dark:text-gray-100">
                                {data.title || "Not specified"}
                            </p>
                        </div>

                        <div className="grid grid-cols-2 gap-4">
                            <div>
                                <p className="text-md font-semibold dark:text-gray-400">
                                    Academic Level
                                </p>
                                <p className="text-sm dark:text-gray-100">
                                    {data.aclevel
                                        ? data.aclevel.split("#")[1]
                                        : "Not specified"}
                                </p>
                            </div>
                            <div>
                                <p className="text-md dark:text-gray-400">
                                    Subject
                                </p>
                                <p className="text-sm dark:text-gray-100">
                                    {data.subject
                                        ? data.subject.split("#")[1]
                                        : "Not specified"}
                                </p>
                            </div>
                            <div>
                                <p className="text-md dark:text-gray-400">
                                    Type of Paper
                                </p>
                                <p className="text-sm dark:text-gray-100">
                                    {data.papertype
                                        ? data.papertype.split("#")[1]
                                        : "Not specified"}
                                </p>
                            </div>

                            <div>
                                <p className="text-md dark:text-gray-400">
                                    Spacing
                                </p>
                                <p className="text-sm dark:text-gray-100">
                                    {data.spacing
                                        ? data.spacing.split("#")[1]
                                        : "Not specified"}
                                </p>
                            </div>
                        </div>
                        <div>
                            <p className="text-md dark:text-gray-400">
                                Urgency
                            </p>
                            <p className="text-sm dark:text-gray-100">
                                {data.deadline
                                    ? data.deadline.split("#")[1] +
                                      " " +
                                      data.deadline.split("#")[2]
                                    : "Not specified"}
                            </p>
                        </div>

                        <div className="grid grid-cols-3 gap-4">
                            <div>
                                <p className="text-md dark:text-gray-400">
                                    Pages
                                </p>
                                <p className="text-md dark:text-gray-100">
                                    {data.pages ? `${data.pages}` : "0"}
                                </p>
                            </div>
                            <div>
                                <p className="text-sm dark:text-gray-400">
                                    Cost per Page
                                </p>
                                <p className="text-sm dark:text-gray-100">
                                    ${costPerPage}
                                </p>
                            </div>
                            <div className="text-right">
                                <p className="text-sm dark:text-gray-400">
                                    Sub Total
                                </p>
                                <p className="text-sm dark:text-gray-100">
                                    ${basePrice}
                                </p>
                            </div>
                        </div>
                        {data.ppslides > 0 && (
                            <div className="grid grid-cols-3 gap-4">
                                <div>
                                    <p className="text-md dark:text-gray-400">
                                        Slides
                                    </p>
                                    <p className="text-sm dark:text-gray-100">
                                        {data.ppslides || "0"}
                                    </p>
                                </div>
                                <div>
                                    <p className="text-md dark:text-gray-400">
                                        Slide Cost
                                    </p>
                                    <p className="text-sm dark:text-gray-100">
                                        $4
                                    </p>
                                </div>
                                <div className="text-right">
                                    <p className="text-md dark:text-gray-400">
                                        Sub Total
                                    </p>
                                    <p className="text-sm dark:text-gray-100">
                                        ${costPerSlide}
                                    </p>
                                </div>
                            </div>
                        )}
                        <div className="pt-4 border-t border-gray-700">
                            <p className="text-md font-bold dark:text-gray-100 text-right">
                                <span className="text-green-700">
                                    Gross Amount:
                                </span>{" "}
                                ${totalAmount}
                            </p>

                            <p className="text-sm font-semibold  text-right mt-2">
                                <span className="text-green-700">
                                    Discount Applied:
                                </span>{" "}
                                ${discount}
                            </p>
                            <p className="text-md font-bold dark:text-gray-100 text-right mt-2">
                                <span className="text-green-700">
                                    Net Amount:
                                </span>{" "}
                                ${netAmount}
                            </p>
                        </div>
                    </div>
                </Card>
            </div>
        </>
    );
}
