import React from "react";

export default function PaymentStatusBadge({ status }) {
    const getStatusStyles = () => {
        switch (status?.toLowerCase()) {
            case "paid":
                return "bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400";
            case "pending":
                return "bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-400";
            case "unpaid":
                return "bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400";
            case "refunded":
                return "bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-400";
            case "partially_refunded":
                return "bg-orange-100 text-orange-800 dark:bg-orange-900/30 dark:text-orange-400";
            default:
                return "bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-400";
        }
    };

    if (!status) return null;

    // Format the status for display (replace underscores with spaces, capitalize)
    const formattedStatus = status
        .replace(/_/g, " ")
        .split(" ")
        .map((word) => word.charAt(0).toUpperCase() + word.slice(1))
        .join(" ");

    return (
        <span
            className={`px-2.5 py-0.5 rounded-full text-xs font-medium ${getStatusStyles()}`}
        >
            {formattedStatus}
        </span>
    );
}
