import React from 'react';
import { Calculator } from 'lucide-react';

export default function PriceCalculatorTrigger({
    onClick,
    variant = 'primary',
    className = '',
    children,
    source = 'button',
}) {
    const baseStyles = 'inline-flex items-center justify-center gap-2 font-medium transition-colors focus:outline-none focus:ring-2 focus:ring-offset-2';

    const variantStyles = {
        primary: 'px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg focus:ring-blue-500',
        secondary: 'px-6 py-3 bg-gray-600 hover:bg-gray-700 text-white rounded-lg focus:ring-gray-500',
        outline: 'px-6 py-3 border-2 border-blue-600 text-blue-600 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded-lg focus:ring-blue-500',
        link: 'text-blue-600 hover:text-blue-700 underline',
        icon: 'p-2 bg-blue-600 hover:bg-blue-700 text-white rounded-full',
    };

    const defaultContent = variant === 'icon' 
        ? <Calculator className="w-5 h-5" />
        : (
            <>
                <Calculator className="w-4 h-4" />
                {children || 'Get Instant Pricing'}
            </>
        );

    return (
        <button
            onClick={onClick}
            className={`${baseStyles} ${variantStyles[variant]} ${className}`}
            data-source={source}
            aria-label="Open price calculator"
        >
            {defaultContent}
        </button>
    );
}

