import React from 'react';

export default function PricingCTA({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section className="py-16 bg-gradient-to-r from-blue-600 to-purple-600">
            <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h2 className="text-3xl md:text-4xl font-bold text-white mb-4">
                    {data.title}
                </h2>
                <p className="text-xl text-blue-100 mb-8 max-w-2xl mx-auto">
                    {data.description}
                </p>

                {/* Limited Time Offer */}
                {data.limitedOffer && (
                    <div className="bg-red-50 border-2 border-red-200 rounded-lg p-6 max-w-4xl mx-auto mb-8">
                        <h3 className="text-xl font-bold text-red-800 mb-2 text-center">
                            {data.limitedOffer.title}
                        </h3>
                        <p className="text-red-700 text-center mb-4">
                            {data.limitedOffer.description}
                        </p>
                        <div className="text-center">
                            <a
                                href={data.limitedOffer.link}
                                className="bg-red-600 hover:bg-red-700 text-white px-8 py-3 rounded-lg font-bold text-lg transition-colors inline-block"
                            >
                                {data.limitedOffer.buttonText}
                            </a>
                        </div>
                    </div>
                )}

                <div className="flex flex-col sm:flex-row gap-4 justify-center mb-8">
                    <a
                        href={data.primaryButtonLink}
                        className="bg-white text-blue-600 hover:bg-gray-100 px-8 py-4 rounded-lg font-bold text-lg transition-colors"
                    >
                        {data.primaryButtonText}
                    </a>
                    <a
                        href={data.secondaryButtonLink}
                        className="border-2 border-white text-white hover:bg-white hover:text-blue-600 px-8 py-4 rounded-lg font-bold text-lg transition-colors"
                    >
                        {data.secondaryButtonText}
                    </a>
                </div>

                {/* Trust Indicators */}
                <div className="flex flex-wrap justify-center items-center gap-8 text-blue-100">
                    {data.trustIndicators && data.trustIndicators.map((indicator, index) => (
                        <div key={index} className="flex items-center">
                            <svg
                                className="w-5 h-5 mr-2"
                                fill="currentColor"
                                viewBox="0 0 20 20"
                            >
                                <path
                                    fillRule="evenodd"
                                    d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                    clipRule="evenodd"
                                />
                            </svg>
                            <span className="text-sm">
                                {indicator.text}
                            </span>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}



