import React from 'react';

export default function PricingContact({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                    {data.title}
                </h2>
                <p className="text-xl text-gray-600 dark:text-gray-300 mb-8">
                    {data.description}
                </p>

                <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-8">
                    {data.contactMethods && data.contactMethods.map((method, index) => (
                        <div key={index} className="text-center">
                            <div className={`${method.iconBgColor} rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4`}>
                                <svg
                                    className={`w-8 h-8 ${method.iconColor}`}
                                    fill="currentColor"
                                    viewBox="0 0 20 20"
                                >
                                    <path d={method.iconPath} />
                                </svg>
                            </div>
                            <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                                {method.title}
                            </h3>
                            <p className="text-gray-600 dark:text-gray-300 mb-2">
                                {method.description}
                            </p>
                            <a
                                href={method.link}
                                className="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-semibold"
                            >
                                {method.linkText}
                            </a>
                        </div>
                    ))}
                </div>

                <div className="bg-blue-50 dark:bg-blue-900/20 rounded-lg p-6">
                    <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                        {data.customQuoteSection.title}
                    </h3>
                    <p className="text-gray-600 dark:text-gray-300 mb-3">
                        {data.customQuoteSection.description}
                    </p>
                    <a
                        href={data.customQuoteSection.link}
                        className="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-semibold inline-flex items-center"
                    >
                        {data.customQuoteSection.linkText}
                        <svg
                            className="w-4 h-4 ml-1"
                            fill="none"
                            stroke="currentColor"
                            viewBox="0 0 24 24"
                        >
                            <path
                                strokeLinecap="round"
                                strokeLinejoin="round"
                                strokeWidth={2}
                                d="M9 5l7 7-7 7"
                            />
                        </svg>
                    </a>
                </div>
            </div>
        </section>
    );
}



