import React from 'react';

export default function PricingFAQs({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center mb-12">
                    <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                        {data.title}
                    </h2>
                    <p className="text-xl text-gray-600 dark:text-gray-300">
                        {data.description}
                    </p>
                </div>

                <div className="space-y-6">
                    {data.faqs && data.faqs.map((faq, index) => (
                        <div
                            key={index}
                            className="bg-white dark:bg-gray-900 rounded-lg shadow-sm"
                        >
                            <details className="group">
                                <summary className="flex justify-between items-center p-6 cursor-pointer">
                                    <h3 className="text-lg font-semibold text-gray-900 dark:text-white pr-4">
                                        {faq.question}
                                    </h3>
                                    <svg
                                        className="w-5 h-5 text-gray-500 dark:text-gray-400 transition-transform group-open:rotate-180"
                                        fill="none"
                                        stroke="currentColor"
                                        viewBox="0 0 24 24"
                                    >
                                        <path
                                            strokeLinecap="round"
                                            strokeLinejoin="round"
                                            strokeWidth={2}
                                            d="M19 9l-7 7-7-7"
                                        />
                                    </svg>
                                </summary>
                                <div className="px-6 pb-6">
                                    <p className="text-gray-600 dark:text-gray-300 leading-relaxed mb-3">
                                        {faq.answer}
                                    </p>
                                    {faq.link && (
                                        <a
                                            href={faq.link}
                                            className="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-semibold text-sm inline-flex items-center"
                                        >
                                            {faq.linkText}
                                            <svg
                                                className="w-4 h-4 ml-1"
                                                fill="none"
                                                stroke="currentColor"
                                                viewBox="0 0 24 24"
                                            >
                                                <path
                                                    strokeLinecap="round"
                                                    strokeLinejoin="round"
                                                    strokeWidth={2}
                                                    d="M9 5l7 7-7 7"
                                                />
                                            </svg>
                                        </a>
                                    )}
                                </div>
                            </details>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}



