import React from 'react';

export default function PricingHero({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section className="bg-gradient-to-r from-blue-600 to-purple-600 py-16 text-white">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h1 className="text-4xl md:text-5xl font-bold mb-6">
                    {data.title}
                </h1>
                <p className="text-xl md:text-2xl mb-8 max-w-3xl mx-auto">
                    {data.description}
                </p>
                <div className="flex flex-col sm:flex-row gap-4 justify-center">
                    <a
                        href={data.primaryButtonLink}
                        className="bg-white text-blue-600 hover:bg-gray-100 px-8 py-4 rounded-lg font-bold text-lg transition-colors"
                    >
                        {data.primaryButtonText}
                    </a>
                    <a
                        href={data.secondaryButtonLink}
                        className="border-2 border-white text-white hover:bg-white hover:text-blue-600 px-8 py-4 rounded-lg font-bold text-lg transition-colors"
                    >
                        {data.secondaryButtonText}
                    </a>
                </div>
                <div className="mt-6 text-sm text-blue-100">
                    <span className="mr-2">Related:</span>
                    {data.relatedLinks && data.relatedLinks.map((link, index) => (
                        <React.Fragment key={index}>
                            <a href={link.url} className="underline hover:text-white mr-3">
                                {link.text}
                            </a>
                        </React.Fragment>
                    ))}
                </div>
            </div>
        </section>
    );
}



