import React from 'react';

export default function PricingTestimonials({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center mb-12">
                    <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                        {data.title}
                    </h2>
                    <p className="text-xl text-gray-600 dark:text-gray-300">
                        {data.description}
                    </p>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    {data.testimonials && data.testimonials.map((testimonial, index) => (
                        <div key={index} className="bg-white dark:bg-gray-900 rounded-lg p-6 shadow-sm">
                            <div className="flex items-center mb-4">
                                <div className="flex text-yellow-400">
                                    {[...Array(testimonial.rating || 5)].map((_, i) => (
                                        <svg
                                            key={i}
                                            className="w-5 h-5"
                                            fill="currentColor"
                                            viewBox="0 0 20 20"
                                        >
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                        </svg>
                                    ))}
                                </div>
                                <span className="ml-2 text-sm text-gray-600 dark:text-gray-300">
                                    {testimonial.service}
                                </span>
                            </div>
                            <blockquote className="text-gray-700 dark:text-gray-300 mb-4 italic">
                                "{testimonial.quote}"
                            </blockquote>
                            <div className="flex items-center justify-between">
                                <div>
                                    <div className="font-semibold text-gray-900 dark:text-white">
                                        {testimonial.author}
                                    </div>
                                    <div className="text-sm text-gray-500 dark:text-gray-400">
                                        {testimonial.position}
                                    </div>
                                </div>
                                <a
                                    href={testimonial.link}
                                    className="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 text-sm font-semibold"
                                >
                                    {testimonial.linkText} →
                                </a>
                            </div>
                        </div>
                    ))}
                </div>

                <div className="text-center mt-8">
                    <a
                        href={data.viewMoreReviewsLink}
                        className="border-2 border-blue-600 text-blue-600 hover:bg-blue-600 hover:text-white px-6 py-3 rounded-lg font-semibold transition-colors"
                    >
                        {data.viewMoreReviewsText}
                    </a>
                </div>
            </div>
        </section>
    );
}



