import React from 'react';

export default function PricingTiers({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section id="pricing" className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center mb-12">
                    <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                        {data.title}
                    </h2>
                    <p className="text-xl text-gray-600 dark:text-gray-300">
                        {data.description}
                    </p>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    {data.tiers && data.tiers.map((tier, index) => (
                        <div
                            key={index}
                            className="bg-white dark:bg-gray-900 rounded-lg shadow-lg p-8 text-center hover:shadow-xl transition-shadow"
                        >
                            <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">
                                {tier.level}
                            </h3>
                            <div className="mb-6">
                                <span className="text-4xl font-bold text-blue-600">
                                    ${tier.startingPrice}
                                </span>
                                <span className="text-gray-600 dark:text-gray-300">
                                    /page
                                </span>
                            </div>
                            <p className="text-gray-600 dark:text-gray-300 mb-6">
                                {tier.description}
                            </p>
                            <div className="space-y-2">
                                <a
                                    href={tier.orderLink}
                                    className="w-full bg-blue-600 hover:bg-blue-700 text-white py-3 px-6 rounded-lg font-semibold transition-colors inline-block"
                                >
                                    Buy Affordable {tier.level} Essays
                                </a>
                                <a
                                    href={tier.serviceLink}
                                    className="w-full border-2 border-blue-600 text-blue-600 hover:bg-blue-600 hover:text-white py-2 px-6 rounded-lg font-semibold transition-colors inline-block text-sm"
                                >
                                    View Essay Services
                                </a>
                            </div>
                        </div>
                    ))}
                </div>

                {/* Price Comparison Section */}
                {data.priceComparison && (
                    <div className="mt-12 bg-green-50 dark:bg-green-900/20 rounded-lg p-8 max-w-4xl mx-auto">
                        <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-6 text-center">
                            {data.priceComparison.title}
                        </h3>
                        <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div className="text-center">
                                <div className="text-3xl font-bold text-red-600 mb-2">{data.priceComparison.competitorPrice}</div>
                                <div className="text-sm text-gray-600 dark:text-gray-300 mb-2">Competitor Prices</div>
                                <div className="text-xs text-gray-500 dark:text-gray-400">Per page</div>
                            </div>
                            <div className="text-center">
                                <div className="text-3xl font-bold text-green-600 mb-2">{data.priceComparison.ourPrice}</div>
                                <div className="text-sm text-gray-600 dark:text-gray-300 mb-2">Our Cheapest Prices</div>
                                <div className="text-xs text-gray-500 dark:text-gray-400">Per page</div>
                            </div>
                            <div className="text-center">
                                <div className="text-3xl font-bold text-blue-600 mb-2">{data.priceComparison.savings}</div>
                                <div className="text-sm text-gray-600 dark:text-gray-300 mb-2">You Save</div>
                                <div className="text-xs text-gray-500 dark:text-gray-400">Every page</div>
                            </div>
                        </div>
                        <div className="text-center mt-6">
                            <a
                                href={data.priceComparison.ctaLink}
                                className="bg-green-600 hover:bg-green-700 text-white px-8 py-3 rounded-lg font-bold text-lg transition-colors inline-block"
                            >
                                {data.priceComparison.ctaText}
                            </a>
                        </div>
                    </div>
                )}

                {/* Internal Links Section */}
                {data.internalLinks && (
                    <div className="mt-12 bg-blue-50 dark:bg-blue-900/20 rounded-lg p-8 max-w-4xl mx-auto">
                        <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-6 text-center">
                            {data.internalLinks.title}
                        </h3>
                        <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div className="text-center">
                                <h4 className="text-lg font-semibold text-gray-900 dark:text-white mb-3">
                                    {data.internalLinks.writersSection.title}
                                </h4>
                                <p className="text-gray-600 dark:text-gray-300 mb-4">
                                    {data.internalLinks.writersSection.description}
                                </p>
                                <a
                                    href={data.internalLinks.writersSection.link}
                                    className="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg font-semibold transition-colors inline-block"
                                >
                                    {data.internalLinks.writersSection.linkText}
                                </a>
                            </div>
                            <div className="text-center">
                                <h4 className="text-lg font-semibold text-gray-900 dark:text-white mb-3">
                                    {data.internalLinks.guaranteesSection.title}
                                </h4>
                                <p className="text-gray-600 dark:text-gray-300 mb-4">
                                    {data.internalLinks.guaranteesSection.description}
                                </p>
                                <a
                                    href={data.internalLinks.guaranteesSection.link}
                                    className="bg-green-600 hover:bg-green-700 text-white px-6 py-3 rounded-lg font-semibold transition-colors inline-block"
                                >
                                    {data.internalLinks.guaranteesSection.linkText}
                                </a>
                            </div>
                        </div>
                    </div>
                )}

                {/* Urgent Delivery Notice */}
                {data.urgentNotice && (
                    <div className="text-center mt-8">
                        <p className="text-gray-600 dark:text-gray-300 mb-4">
                            {data.urgentNotice.disclaimer}
                        </p>
                        <div className="bg-blue-50 dark:bg-blue-900/20 rounded-lg p-6 max-w-4xl mx-auto">
                            <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                                {data.urgentNotice.title}
                            </h3>
                            <p className="text-gray-700 dark:text-gray-300 mb-3">
                                {data.urgentNotice.description}
                            </p>
                            <a
                                href={data.urgentNotice.link}
                                className="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-semibold text-sm inline-flex items-center"
                            >
                                {data.urgentNotice.linkText}
                                <svg
                                    className="w-4 h-4 ml-1"
                                    fill="none"
                                    stroke="currentColor"
                                    viewBox="0 0 24 24"
                                >
                                    <path
                                        strokeLinecap="round"
                                        strokeLinejoin="round"
                                        strokeWidth={2}
                                        d="M9 5l7 7-7 7"
                                    />
                                </svg>
                            </a>
                        </div>
                    </div>
                )}
            </div>
        </section>
    );
}



