import React from 'react';
import OptimizedImage from '@/Components/OptimizedImage';

export default function ServiceImageSection({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h2 className="text-3xl font-bold text-gray-900 dark:text-white mb-8">
                    {data.title}
                </h2>
                
                <OptimizedImage
                    src={data.imageSrc}
                    alt={data.imageAlt}
                    className="w-full h-[400px] sm:h-[500px] lg:h-[600px] object-cover"
                    priority={true}
                    width={600}
                    height={600}
                    sizes="(max-width: 768px) 100vw, (max-width: 1024px) 50vw, 600px"
                />
                
                <p className="text-gray-600 dark:text-gray-300 mt-4 max-w-2xl mx-auto">
                    {data.description}
                </p>
                
                <div className="mt-6">
                    <a
                        href={data.exploreLink}
                        className="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-semibold inline-flex items-center"
                    >
                        {data.exploreText}
                        <svg
                            className="w-4 h-4 ml-1"
                            fill="none"
                            stroke="currentColor"
                            viewBox="0 0 24 24"
                        >
                            <path
                                strokeLinecap="round"
                                strokeLinejoin="round"
                                strokeWidth={2}
                                d="M9 5l7 7-7 7"
                            />
                        </svg>
                    </a>
                </div>
            </div>
        </section>
    );
}



