import { useState } from "react";
import { ChevronDown, ChevronUp, Minus, Plus } from "lucide-react";

const SectionContainer = ({
    children,
    className = "",
    title,
    defaultExpanded = true,
    titleClassName = "",
}) => {
    const [isExpanded, setIsExpanded] = useState(defaultExpanded);

    const toggleExpand = () => {
        setIsExpanded(!isExpanded);
    };

    return (
        <section
            className={`bg-white/90 dark:bg-gray-800/90 backdrop-blur-sm border border-gray-300 dark:border-gray-600 shadow-lg rounded-xl overflow-hidden ${className}`}
        >
            {/* Header with toggle button */}
            <div
                className={`px-6 py-4 flex justify-between items-center cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors ${titleClassName}`}
                onClick={toggleExpand}
            >
                <h3 className="font-semibold text-lg">{title || "Section Title"}</h3>
                <button
                    type="button"
                    className="text-gray-700 dark:text-gray-300 hover:text-gray-900 dark:hover:text-gray-100 focus:outline-none transition-transform duration-200"
                    aria-expanded={isExpanded}
                >
                    {isExpanded ? (
                        <ChevronUp className="w-5 h-5" />
                    ) : (
                        <ChevronDown className="w-5 h-5" />
                    )}
                </button>
            </div>

            {/* Content area with animation */}
            <div
                className={`transition-all duration-300 overflow-hidden ${
                    isExpanded
                        ? "max-h-[2000px] opacity-100"
                        : "max-h-0 opacity-0"
                }`}
            >
                <div className="px-6 py-6">{children}</div>
            </div>
        </section>
    );
};

export default SectionContainer;
