import React from "react";

export default function SectionHeader({ eyebrow, title, subtitle, align = "center", className = "" }) {
  const alignCls = align === "left" ? "text-left items-start" : align === "right" ? "text-right items-end" : "text-center items-center";
  return (
    <div className={`flex flex-col gap-2 ${alignCls} ${className}`}>
      {eyebrow && (
        <span className="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-50 text-blue-700 border border-blue-100">
          {eyebrow}
        </span>
      )}
      {title && <h2 className="text-2xl sm:text-3xl font-bold tracking-tight text-gray-900">{title}</h2>}
      {subtitle && <p className="text-gray-600 max-w-2xl">{subtitle}</p>}
    </div>
  );
}


