import PropTypes from "prop-types";

export default function ScrollableContentSection({
    eyebrow,
    title,
    description,
    sections = [],
    height = 480,
}) {
    if (!sections.length) {
        return null;
    }

    return (
        <section className="py-12 sm:py-16 bg-slate-50 dark:bg-slate-900">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center max-w-3xl mx-auto mb-10">
                    {eyebrow && (
                        <p className="text-sm font-semibold tracking-wide uppercase text-slate-500 dark:text-slate-300">
                            {eyebrow}
                        </p>
                    )}
                    {title && (
                        <h2 className="mt-3 text-2xl sm:text-3xl font-bold text-slate-900 dark:text-white">
                            {title}
                        </h2>
                    )}
                    {description && (
                        <div 
                            className="mt-4 text-base sm:text-lg text-slate-600 dark:text-slate-300 prose prose-sm max-w-none content-area"
                            dangerouslySetInnerHTML={{ __html: description }}
                        />
                    )}
                </div>

                <div className="relative">
                    <div
                        className="group rounded-3xl border border-slate-200/70 dark:border-slate-700/70 bg-white dark:bg-slate-950 shadow-xl shadow-slate-900/5 dark:shadow-black/30"
                    >
                        <div
                            className="overflow-y-auto scrollbar-thin scrollbar-thumb-slate-300 scrollbar-track-transparent dark:scrollbar-thumb-slate-700"
                            style={{ maxHeight: `${height}px` }}
                        >
                            <div className="grid gap-6 p-6 sm:p-8 md:grid-cols-2">
                                {sections.map((section, index) => (
                                    <article
                                        key={index}
                                        className="rounded-2xl border border-slate-200/70 dark:border-slate-800 bg-slate-50 dark:bg-slate-900/60 p-5 sm:p-6"
                                    >
                                        {section.title && (
                                            <h3 className="text-lg font-semibold text-slate-900 dark:text-white mb-3">
                                                {section.title}
                                            </h3>
                                        )}
                                        {section.html && (
                                            <div
                                                className="prose prose-sm sm:prose dark:prose-invert prose-headings:text-slate-900 prose-headings:dark:text-white prose-strong:text-slate-900 prose-strong:dark:text-slate-100 prose-a:text-blue-600 dark:prose-a:text-blue-400 content-area"
                                                dangerouslySetInnerHTML={{ __html: section.html }}
                                            />
                                        )}
                                    </article>
                                ))}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    );
}

ScrollableContentSection.propTypes = {
    eyebrow: PropTypes.string,
    title: PropTypes.string,
    description: PropTypes.string,
    sections: PropTypes.arrayOf(
        PropTypes.shape({
            title: PropTypes.string,
            html: PropTypes.string,
        })
    ),
    height: PropTypes.number,
};

