import { motion } from "framer-motion";
import { Link } from "@inertiajs/react";
import {
    Users,
    BookOpen,
    Award,
    Clock,
    Star,
    Globe,
    TrendingUp,
    CheckCircle,
    GraduationCap,
    FileText,
    Heart,
    Shield,
    Target,
    Zap,
} from "lucide-react";

export default function Stats({ fadeIn, staggerContainer }) {
    const handleStatClick = (statName, statValue) => {
        if (typeof window.trackStatView === "function") {
            window.trackStatView(statName, statValue, "stats_section");
        }
    };

    const handleCTAClick = (ctaText, section) => {
        if (typeof window.trackCTAClick === "function") {
            window.trackCTAClick(ctaText, "stats_section", section);
        }
    };

    const mainStats = [
        {
            number: "98%",
            label: "Client Satisfaction Rate",
            description: "Students recommend our academic writing services",
            icon: <Heart className="w-12 h-12 text-red-500" />,
            color: "from-red-500 to-pink-500",
            detail: "Based on 1,200+ verified reviews",
        },
        {
            number: "1,250+",
            label: "Completed Academic Projects",
            description: "Successfully delivered custom academic papers",
            icon: <BookOpen className="w-12 h-12 text-blue-500" />,
            color: "from-blue-500 to-cyan-500",
            detail: "Across all academic levels",
        },
        {
            number: "180+",
            label: "Professional Essay Writers",
            description: "PhD and Master's level academic experts",
            icon: <Users className="w-12 h-12 text-green-500" />,
            color: "from-green-500 to-emerald-500",
            detail: "Rigorously vetted and qualified",
        },
        {
            number: "35+",
            label: "Academic Disciplines Covered",
            description: "Comprehensive subject matter expertise",
            icon: <Target className="w-12 h-12 text-purple-500" />,
            color: "from-purple-500 to-indigo-500",
            detail: "From humanities to STEM fields",
        },
    ];

    const additionalStats = [
        {
            number: "99.8%",
            label: "On-Time Delivery",
            description: "Reliable dissertation writing help",
            icon: <Clock className="w-8 h-8 text-orange-500" />,
        },
        {
            number: "24/7",
            label: "Customer Support",
            description: "Round-the-clock assistance",
            icon: <Globe className="w-8 h-8 text-blue-500" />,
        },
        {
            number: "100%",
            label: "Original Content",
            description: "Plagiarism-free guarantee",
            icon: <Shield className="w-8 h-8 text-green-500" />,
        },
        {
            number: "5+ Years",
            label: "Industry Experience",
            description: "Trusted research paper writing service",
            icon: <Award className="w-8 h-8 text-yellow-500" />,
        },
        {
            number: "4.9/5",
            label: "Average Rating",
            description: "Exceptional service quality",
            icon: <Star className="w-8 h-8 text-yellow-400" />,
        },
        {
            number: "72 Hours",
            label: "Fastest Turnaround",
            description: "Urgent academic writing available",
            icon: <Zap className="w-8 h-8 text-red-500" />,
        },
    ];

    const serviceHighlights = [
        {
            title: "Dissertation Writing Help",
            description: "PhD-level support for doctoral students",
            count: "450+",
            icon: <GraduationCap className="w-6 h-6" />,
        },
        {
            title: "Research Paper Writing Service",
            description: "Comprehensive research and analysis",
            count: "680+",
            icon: <FileText className="w-6 h-6" />,
        },
        {
            title: "Custom Academic Papers",
            description: "Tailored to specific requirements",
            count: "920+",
            icon: <BookOpen className="w-6 h-6" />,
        },
        {
            title: "Professional Essay Writers",
            description: "Expert writers across all disciplines",
            count: "180+",
            icon: <Users className="w-6 h-6" />,
        },
    ];

    return (
        <>
            {/* Writer Statistics Section */}
            <section className="w-full bg-white dark:bg-gray-800 py-16">
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <motion.div
                        initial="hidden"
                        whileInView="visible"
                        viewport={{ once: true }}
                        variants={fadeIn}
                        className="text-center mb-12"
                    >
                        <h3 className="text-3xl font-bold text-gray-900 dark:text-white mb-4">
                            Our Professional Essay Writers by the Numbers
                        </h3>
                        <p className="text-lg text-gray-600 dark:text-gray-300 max-w-3xl mx-auto">
                            The qualified professionals behind our exceptional{" "}
                            <strong>custom academic papers</strong>
                        </p>
                    </motion.div>

                    <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                        {/* Writer Stats */}
                        <motion.div
                            initial="hidden"
                            whileInView="visible"
                            viewport={{ once: true }}
                            variants={staggerContainer}
                            className="space-y-6"
                        >
                            {[
                                {
                                    label: "PhD Holders",
                                    count: "120+",
                                    description:
                                        "Doctoral-level expertise for dissertation writing help",
                                    percentage: 67,
                                },
                                {
                                    label: "Master's Degree Writers",
                                    count: "60+",
                                    description:
                                        "Advanced degree professionals for research papers",
                                    percentage: 33,
                                },
                                {
                                    label: "Years of Experience",
                                    count: "8+ Avg",
                                    description:
                                        "Extensive background in academic writing services",
                                    percentage: 85,
                                },
                                {
                                    label: "Published Authors",
                                    count: "45+",
                                    description:
                                        "Writers with published academic research",
                                    percentage: 25,
                                },
                            ].map((stat, index) => (
                                <motion.div
                                    key={index}
                                    variants={fadeIn}
                                    className="flex items-center space-x-4"
                                >
                                    <div className="flex-shrink-0 w-20 text-right">
                                        <div className="text-2xl font-bold text-blue-600 dark:text-blue-400">
                                            {stat.count}
                                        </div>
                                    </div>
                                    <div className="flex-grow">
                                        <div className="flex items-center justify-between mb-1">
                                            <h4 className="font-semibold text-gray-900 dark:text-white">
                                                {stat.label}
                                            </h4>
                                        </div>
                                        <div className="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2 mb-2">
                                            <div
                                                className="bg-gradient-to-r from-blue-500 to-purple-600 h-2 rounded-full transition-all duration-1000"
                                                style={{
                                                    width: `${stat.percentage}%`,
                                                }}
                                            ></div>
                                        </div>
                                        <p className="text-sm text-gray-600 dark:text-gray-300">
                                            {stat.description}
                                        </p>
                                    </div>
                                </motion.div>
                            ))}
                        </motion.div>

                        {/* Writer Qualifications Visual */}
                        <motion.div
                            initial="hidden"
                            whileInView="visible"
                            viewport={{ once: true }}
                            variants={fadeIn}
                            className="bg-gradient-to-br from-blue-50 to-purple-50 dark:from-gray-700 dark:to-gray-600 rounded-2xl p-8"
                        >
                            <h4 className="text-2xl font-bold text-gray-900 dark:text-white mb-6 text-center">
                                Writer Expertise Distribution
                            </h4>
                            <div className="grid grid-cols-2 gap-4">
                                {[
                                    {
                                        field: "STEM Fields",
                                        count: "45",
                                        color: "bg-blue-500",
                                    },
                                    {
                                        field: "Humanities",
                                        count: "38",
                                        color: "bg-green-500",
                                    },
                                    {
                                        field: "Business",
                                        count: "32",
                                        color: "bg-purple-500",
                                    },
                                    {
                                        field: "Social Sciences",
                                        count: "28",
                                        color: "bg-orange-500",
                                    },
                                    {
                                        field: "Health Sciences",
                                        count: "25",
                                        color: "bg-red-500",
                                    },
                                    {
                                        field: "Education",
                                        count: "22",
                                        color: "bg-indigo-500",
                                    },
                                ].map((field, index) => (
                                    <div
                                        key={index}
                                        className="text-center p-4 bg-white dark:bg-gray-800 rounded-lg shadow-sm"
                                    >
                                        <div
                                            className={`w-12 h-12 ${field.color} rounded-full flex items-center justify-center mx-auto mb-2`}
                                        >
                                            <span className="text-white font-bold">
                                                {field.count}
                                            </span>
                                        </div>
                                        <h5 className="font-semibold text-gray-900 dark:text-white text-sm">
                                            {field.field}
                                        </h5>
                                    </div>
                                ))}
                            </div>
                        </motion.div>
                    </div>
                </div>
            </section>
        </>
    );
}
